function PlaylistScrollBar() {
	this.buttons = new Array(3);
	this.visible = false;
// manage if total display is below the # of rows then dont show the scrollbar

	this.draw = function (gr, x, y) {
		// draw background and buttons up & down
		gr.FillRectangle(this.x, this.y, this.w, this.h, pl_organizer.scrollColor & 0x15ffffff);
		// draw up & down buttons
		this.buttons[cScrollBar.buttonType.up] && this.buttons[cScrollBar.buttonType.up].draw(gr, this.x, this.y);
		this.buttons[cScrollBar.buttonType.down] && this.buttons[cScrollBar.buttonType.down].draw(gr, this.x, this.y + this.h - this.w);

		// draw cursor
		this.buttons[cScrollBar.buttonType.cursor] && this.buttons[cScrollBar.buttonType.cursor].draw(gr, this.x, this.cursorPos);
	}

	this.setCursor = function (totalRowVisible, totalRows, offset) {
		if (totalRows > 0 && totalRows > totalRowVisible && this.w > 2) {
			pl_organizer.w = window.Width - cScrollBar.width - 5;
			this.visible = true;
			this.cursorWidth = this.w;
			// calc cursor heightpl_organizer.scrollColor
			this.cursorHeight = Math.round((totalRowVisible / totalRows) * this.area_h);
			if (this.cursorHeight < this.w - 2 || this.cursorHeight > this.h)
				this.cursorHeight = this.w - 2;
			// cursor pos
			var ratio = offset / (totalRows - totalRowVisible);
			this.cursorPos = this.area_y + Math.round((this.area_h - this.cursorHeight) * ratio);
			this.setCursorButton();
		}
		else {
			pl_organizer.w = window.Width;
			this.visible = false;
        }
	}

	this.setCursorButton = function () {
		if (!this.cursorWidth || !this.cursorHeight) return;
		this.cursorImage_normal = utils.CreateImage(this.cursorWidth, this.cursorHeight);
		var gb = this.cursorImage_normal.GetGraphics();

		gb.FillRectangle(0, 0, this.cursorWidth, this.cursorHeight, pl_organizer.scrollColor & 0x33ffffff);
		this.cursorImage_normal.ReleaseGraphics();

		// hover cursor Image
		this.cursorImage_hover = utils.CreateImage(this.cursorWidth, this.cursorHeight);
		gb = this.cursorImage_hover.GetGraphics();
		gb.FillRectangle(0, 0, this.cursorWidth, this.cursorHeight, pl_organizer.scrollColor & 0x55ffffff);
		this.cursorImage_hover.ReleaseGraphics();

		// down cursor Image
		this.cursorImage_down = utils.CreateImage(this.cursorWidth, this.cursorHeight);
		gb = this.cursorImage_down.GetGraphics();
		gb.FillRectangle(0, 0, this.cursorWidth, this.cursorHeight, pl_organizer.scrollColor & 0x99ffffff);
		this.cursorImage_down.ReleaseGraphics();
		// create/refresh cursor Button in buttons array
		this.buttons[cScrollBar.buttonType.cursor] = new button(this.cursorImage_normal, this.cursorImage_hover, this.cursorImage_down);
	}

	this.setButtons = function () {
		// normal scroll_up Image
		this.upImage_normal = utils.CreateImage(this.w, this.w);
		var gb = this.upImage_normal.GetGraphics();
		gb.WriteText(chars.up, pl_organizer.fonts.awesome12, pl_organizer.scrollColor & 0x55ffffff, 0, 0, this.w, this.w, 2, 2);
		this.upImage_normal.ReleaseGraphics();

		// hover scroll_up Image
		this.upImage_hover = utils.CreateImage(this.w, this.w);
		gb = this.upImage_hover.GetGraphics();
		gb.WriteText(chars.up, pl_organizer.fonts.awesome12, pl_organizer.scrollColor & 0x99ffffff, 0, 0, this.w, this.w, 2, 2);
		this.upImage_hover.ReleaseGraphics();

		// down scroll_up Image
		this.upImage_down = utils.CreateImage(this.w, this.w);
		gb = this.upImage_down.GetGraphics();
		gb.WriteText(chars.up, pl_organizer.fonts.awesome12, pl_organizer.scrollColor, 0, 0, this.w, this.w, 2, 2);
		this.upImage_down.ReleaseGraphics();

		// normal scroll_down Image
		this.downImage_normal = utils.CreateImage(this.w, this.w);
		gb = this.downImage_normal.GetGraphics();
		gb.WriteText(chars.down, pl_organizer.fonts.awesome12, pl_organizer.scrollColor & 0x55ffffff, 0, 0, this.w, this.w, 2, 2);
		this.downImage_normal.ReleaseGraphics();

		// hover scroll_down Image
		this.downImage_hover = utils.CreateImage(this.w, this.w);
		gb = this.downImage_hover.GetGraphics();
		gb.WriteText(chars.down, pl_organizer.fonts.awesome12, pl_organizer.scrollColor & 0x99ffffff, 0, 0, this.w, this.w, 2, 2);
		this.downImage_hover.ReleaseGraphics();

		// down scroll_down Image
		this.downImage_down = utils.CreateImage(this.w, this.w);
		gb = this.downImage_down.GetGraphics();
		gb.WriteText(chars.down, pl_organizer.fonts.awesome12, pl_organizer.scrollColor, 0, 0, this.w, this.w, 2, 2);
		this.downImage_down.ReleaseGraphics();

		this.buttons[cScrollBar.buttonType.up] = new button(this.upImage_normal, this.upImage_hover, this.upImage_down);
		this.buttons[cScrollBar.buttonType.down] = new button(this.downImage_normal, this.downImage_hover, this.downImage_down);
	}

	this.setSize = function (x, y, w, h) {
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		// scrollbar area for the cursor (<=> scrollbar height minus up & down buttons height)
		this.area_y = y + w;
		this.area_h = h - (w * 2);
		this.setButtons();
	}

	this.setOffsetFromCursorPos = function () {
		// calc ratio of the scroll cursor to calc the equivalent item for the full playlist (with gh)
		var ratio = (this.cursorPos - this.area_y) / (this.area_h - this.cursorHeight);
		// calc idx of the item (of the full playlist with gh) to display at top of the panel list (visible)
		var newOffset = Math.round((pl_organizer.items - pl_organizer.rows) * ratio);
		return newOffset;
	}

	this.cursorCheck = function (event, x, y) {
		this.ishover = (x >= this.x && x <= this.x + this.w && y >= this.cursorPos && y <= (this.cursorPos + this.cursorHeight));
		this.isHoverEmptyArea = (x >= this.x && x <= this.x + this.w && y >= this.y + this.buttonHeight && y <= this.cursorAreaY + this.cursorAreaHeight) && !this.isHoverCursor;
		switch (event) {
			case "lbtn_down":
			case "lbtn_dblclk":
				this.buttons[0] && this.buttons[0].checkstate(event, x, y);
				if (this.ishover) {
					this.cursorClickX = x;
					this.cursorClickY = y;
					this.cursorDrag = true;
					this.cursorDragDelta = y - this.cursorPos;
					this.clicked = true;
				}
				if (this.hover && !this.cursorDrag) {
					var scrollstep = pl_organizer.rows /3;
					if (y < this.cursorPos) {
							pl_organizer.wheel(scrollstep);
						if (!cScrollBar.timerID) {
							cScrollBar.timerID = window.SetInterval(function () {
								if (cScrollBar.timer_counter > 3 ) {
									pl_organizer.wheel(scrollstep);
								} else {
									cScrollBar.timer_counter++;
								}
							}, 80);
						}
						
					} else {
						pl_organizer.wheel(-scrollstep);
						if (!cScrollBar.timerID) {
							cScrollBar.timerID = window.SetInterval(function () {
								if (cScrollBar.timer_counter > 3) {
									pl_organizer.wheel(-scrollstep);
								} else {
									cScrollBar.timer_counter++;
								}
							}, 80);
						}
					}
					window.repaint();
				}
				break;
			case "lbtn_up":
				if (cScrollBar.timerID) {
					window.ClearInterval(cScrollBar.timerID);
					cScrollBar.timerID = false;
				}
				this.buttons[0] && this.buttons[0].checkstate(event, x, y);
				if (this.cursorDrag) {
					pl_organizer.offset = this.setOffsetFromCursorPos();
					window.repaint();
				}
				this.cursorClickX = 0;
				this.cursorClickY = 0;
				this.cursorDrag = false;
				this.clicked = false;
				break;
			case "move":
				this.buttons[0] && this.buttons[0].checkstate(event, x, y);
					if (this.cursorDrag) {
					this.cursorPos = y - this.cursorDragDelta;
					if (this.cursorPos + this.cursorHeight > this.area_y + this.area_h) {
						this.cursorPos = (this.area_y + this.area_h) - this.cursorHeight;
					}
					if (this.cursorPos < this.area_y) {
						this.cursorPos = this.area_y;
					}
					pl_organizer.offset = this.setOffsetFromCursorPos();
					if (!g_mouse_wheel_timeout) {
						g_mouse_wheel_timeout = window.SetTimeout(function () {
						g_mouse_wheel_timeout = false;
						window.Repaint();
						}, 30);
					}
				}
				break;
		}
	}

	this.isHoverObject = function (x, y) {
		return (x >= this.x && x <= this.x + this.w && y > this.area_y && y < this.area_y + this.area_h);
	}

	this.check = function (event, x, y) {
		this.hover = this.isHoverObject(x, y);

		// check cursor
		this.cursorCheck(event, x, y);

		// check other buttons
		for (var i = 1; i < this.buttons.length; i++) {
			switch (event) {
			case "lbtn_dblclk":
			case "lbtn_down":
				switch (i) {
				case 1: // up button
					if (this.buttons[i] && this.buttons[i].checkstate(event, x, y) == ButtonStates.down) {
						this.clicked = true;
						this.list_buttonclicked = true;
						cScrollBar.timer_counter = 0;
						pl_organizer.offset = pl_organizer.offset > 0 ? pl_organizer.offset - 1 : 0;
						p_scrollbar.setCursor(pl_organizer.rows, pl_organizer.items, pl_organizer.offset);
						window.repaint();
						if (!cScrollBar.interval) {
							cScrollBar.interval = window.SetInterval(function () {
								cScrollBar.timer_counter++;
								if (cScrollBar.timer_counter > 3) {
									pl_organizer.offset = pl_organizer.offset > 0 ? pl_organizer.offset - 1 : 0;
									p_scrollbar.setCursor(pl_organizer.rows, pl_organizer.items, pl_organizer.offset);
									window.repaint();
								}
							}, 60);
						}
					}
					break;
				case 2: // down button
					if (this.buttons[i] && this.buttons[i].checkstate(event, x, y) == ButtonStates.down) {
						this.clicked = true;
						this.list_buttonclicked = true;
						cScrollBar.timer_counter = 0;
						pl_organizer.offset = pl_organizer.offset >= (pl_organizer.items - pl_organizer.rows) ? (pl_organizer.items - pl_organizer.rows) : pl_organizer.offset + 1;
						p_scrollbar.setCursor(pl_organizer.rows, pl_organizer.items, pl_organizer.offset);
						window.repaint();
						if (!cScrollBar.interval) {
							cScrollBar.interval = window.SetInterval(function () {
								cScrollBar.timer_counter++;
								if (cScrollBar.timer_counter > 3) {
									pl_organizer.offset = pl_organizer.offset >= (pl_organizer.items - pl_organizer.rows) ? (pl_organizer.items - pl_organizer.rows) : pl_organizer.offset + 1;
									p_scrollbar.setCursor(pl_organizer.rows, pl_organizer.items, pl_organizer.offset);
									window.repaint();
								}
							}, 60);
						}
					}
					break;
				}
				break;
			case "lbtn_up":
				if (cScrollBar.interval) {
					window.ClearInterval(cScrollBar.interval);
					cScrollBar.interval = false;
				}
				cScrollBar.timer_counter = 0;
				this.buttons[i] && this.buttons[i].checkstate(event, x, y);
				this.clicked = false;
				break;
			default:
				this.buttons[i] && this.buttons[i].checkstate(event, x, y);
			}
		}



	}
}

function button(normal, hover, down) {
	this.img = [normal, hover, down];
	this.w = this.img[0].Width;
	this.h = this.img[0].Height;
	this.state = ButtonStates.normal;

	this.update = function (normal, hover, down) {
		this.img = [normal, hover, down];
		this.w = this.img[0].Width;
		this.h = this.img[0].Height;
	}

	this.draw = function (gr, x, y) {
		this.x = x;
		this.y = y;
		if (this.img[this.state]) {
			gr.DrawImage(this.img[this.state], this.x, this.y, this.w, this.h, 0, 0, this.w, this.h);
		}
	}

	this.checkstate = function (event, x, y) {
		this.ishover = (x > this.x && x < this.x + this.w - 1 && y > this.y && y < this.y + this.h - 1);
		var old = this.state;
		switch (event) {
			case "lbtn_down":
				switch (this.state) {
					case ButtonStates.normal:
					case ButtonStates.hover:
						this.state = this.ishover ? ButtonStates.down : ButtonStates.normal;
						this.isdown = true;
						break;
				}
				break;
			case "lbtn_up":
				this.state = this.ishover ? ButtonStates.hover : ButtonStates.normal;
				this.isdown = false;
				break;
			case "move":
				switch (this.state) {
					case ButtonStates.normal:
					case ButtonStates.hover:
						this.state = this.ishover ? ButtonStates.hover : ButtonStates.normal;
						break;
				}
				break;
		}

		if (this.state != old) {
			window.RepaintRect(this.x, this.y, this.w, this.h);
		}
		return this.state;
	}
}

var g_mouse_wheel_timeout = false;



var ButtonStates = {
	normal: 0,
	hover: 1,
	down: 2
};
