var statusFile = fb.ProfilePath + "pl_organizer.txt";
if (utils.IsFile(statusFile) == false) {
    utils.WriteTextFile(statusFile, "");
}
var archiveFile = fb.ProfilePath + "pl_organizerArchive.txt";
if (utils.IsFile(archiveFile) == false)
    archiveFileStatus = false
else archiveFileStatus = true;

var themeFile = fb.ProfilePath + "pl_organizer_theme.txt";
if (utils.IsFile(themeFile) == false)
    themeFileStatus = false
else themeFileStatus = true;

 
var cScrollBar = {
   // defaultWidth: 17,
    width: 18,
    buttonType: {
        cursor: 0,
        up: 1,
        down: 2
    },
    timerID: false,
    timer_counter: 0,
};
 
var selected = {
    index: -1,
    pl: 0
}
 
var folderIcon = [{
        "close": '\uf07b',
        "open": '\uf07c'
    },
    {
        "close": '\uf0da',
        "open": '\uf0d7'
    }
];
 
var Separator = ['', ' ', '.', ','];
var units = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
 
var g_wallpaperImg = null;
//var showNumb = true;
 
TM = _scale(15);
 
var VK_ADD = 0x6B;
var VK_END = 0x23;
var VK_F2 = 0x71;
var VK_HOME = 0x24;
var VK_LEFT = 0x25;
var VK_NEXT = 0x22;
var VK_PRIOR = 0x21;
var VK_RIGHT = 0x27;
var VK_SUBTRACT = 0x6D;
 
chars["body"] = '\uF007';
chars["locked"] = '\uf023';
chars["number"] = '\uf0cb';
chars["pdf"] = '\uf1c1';
chars["sound"] = '\uf001';
chars["state1"] = '\uF150';
chars["state2"] = '\uF152';
chars["weight"] = '\uf0a0';
 
function _pl_organizer() {
    this.size = function () {
        this.panel_h = window.Height;
        this.panel_w = window.Width;
        this.h = window.Height - (TM * this.header);
        this.rows = Math.floor((this.h - _scale(1)) / this.row_height);
        if (this.items <= this.rows) {
            this.w = window.Width;
        } else {
            this.w = window.Width - cScrollBar.width - 5;
            p_scrollbar.visible = true;
        }
        p_scrollbar.setSize(this.panel_w - cScrollBar.width, this.ylist, cScrollBar.width, this.h);
        p_scrollbar.setCursor(this.rows, this.items, this.offset);
    }

    this.setSel = function (index) {
        selected.index = index;
        selected.pl = this.display[index].pl;
    }
    this.paint = function (gr) {
        if (this.items == 0) {
            return;
        }
        this.truncedId = [];
        // Background
        if (this.bgpic && g_wallpaperImg) {
            gr.FillRectangle(0, 0, this.panel_w, this.panel_h, this.colours_background);
            // gr.DrawImage(g_wallpaperImg, 0, 0, this.panel_w, this.panel_h, 0, 0, g_wallpaperImg.Width, g_wallpaperImg.Height, 0.1);
            // stretch = 2 ; center = 3
            _drawImage(gr, g_wallpaperImg, 0, 0, this.panel_w, this.panel_h, this.BGaspect_value, (this.opacity_perc_value - 100) / 100);
        }
        else
            gr.FillRectangle(0, 0, this.panel_w, this.panel_h, this.colours_background);
        // draw header
        if (this.header) {
            gr.WriteText("# " + this.data.filter(function (artr) {
                return artr.pl == 1;
            }).length, this.fonts_folder, this.text_color, LM, 0 - 2, this.panel_w - (LM * 2), TM, DWRITE_TEXT_ALIGNMENT_LEADING, DWRITE_PARAGRAPH_ALIGNMENT_CENTER, DWRITE_WORD_WRAPPING_NO_WRAP, DWRITE_TRIMMING_GRANULARITY_CHARACTER);
            gr.DrawLine(LM, TM + 5, this.panel_w - (LM * 2), TM + 5, 1, this.headerline_color);
        }
        var col = this.text_color;

        // paint the list

        var playing_item_location = plman.GetPlayingItemLocation();
        for (var i = 0; i < Math.min(this.items, this.rows); i++) {
            var fold_numbers = 0;
            var indent = this.display[i + this.offset].lvl * 23;
            if (this.display[i + this.offset].pl == 0) {
                // paint a folder
                var fold = this.display[i + this.offset].name;
                fold_numbers = this.data.filter(function (artr) { //count of playlists in that folder (from this.data because display have excluded them)
                    return artr.fold == fold;
                }).length;
                var fold = (this.display[i + this.offset].foldState == '1' ? folderIcon[this.folderIcon].open : folderIcon[this.folderIcon].close);
                var font = this.foldertext_weight == 1 ? this.fonts_folder_bold : this.fonts_folder;
                gr.WriteText(fold, this.fonts.awesome, this.folderIcon_color, indent + this.off, this.ylist + this.layerUp + (i * this.row_height) + 5, this.calc_text_width(fold, this.fonts.awesome) + 20, this.row_height);
                gr.WriteText(" " + this.display[i + this.offset].name + " [" + fold_numbers + "]", font, this.folder_color, indent + this.off + this.calc_text_width(fold, font) + 5, this.ylist + this.layerUp + (i * this.row_height), this.panel_w, this.row_height);
                var disp = _formatNumber(this.display[i + this.offset].value, this.thousandSeparator);
                gr.WriteText(disp, font, this.folder_color, this.w - this.calc_text_width(disp, font) - 4, this.ylist + this.layerUp + (i * this.row_height), this.calc_text_width(disp, font) + 20, this.row_height);
            }
            else {
                // paint a playlist
                var disp;
                switch (this.displayStats) {
                    case 0:
                        disp = _formatNumber(this.display[i + this.offset].value, this.thousandSeparator);
                        break;
                    case 1:
                        disp = niceBytes(this.display[i + this.offset].size);
                        break;
                    case 2:
                        disp = "#" + _formatNumber(this.display[i + this.offset].value, this.thousandSeparator) + " | " + niceBytes(this.display[i + this.offset].size);
                        break;
                    case 3:
                        disp = millisecondsToStr(plman.GetPlaylistItems(plman.FindByGUID(this.display[i + this.offset].id)).CalcTotalDuration())
                        break;
                }
                if (playing_item_location.IsValid) {
                    // file played
                    if (this.display[i + this.offset].name == plman.GetPlaylistName(playing_item_location.PlaylistIndex))
                        if (this.activeSongOption)
                            gr.WriteText(chars.sound, this.fonts.awesome, this.but_color, 5, this.ylist + this.layerUp + (i * this.row_height) + 3, 25, this.row_height);
                        else col = this.activeSong_color;
                }

                // playlist name
                if (this.calc_text_width(this.display[i + this.offset].name, this.fonts_playlist) > (this.panel_w - (this.calc_text_width(disp, this.fonts) + indent + this.nodeIndent + this.off) - 35))
                    this.truncedId.push(this.display[i + this.offset].id);

                gr.WriteText(this.display[i + this.offset].name, this.fonts_playlist, col, indent + this.nodeIndent + this.off, this.ylist + this.layerUp + (i * this.row_height), this.panel_w - (this.calc_text_width(disp, this.fonts) + indent + this.nodeIndent + this.off) - 35, this.row_height);
                var plId = plman.FindByGUID(this.display[i + this.offset].id);
                if ((!playlist_can_remove(plId) || !playlist_can_add(plId) || !playlist_can_rename(plId)) && this.lockStatus == 1) {
                    gr.WriteText(chars["locked"], this.fonts.awesome, col, indent + this.nodeIndent + this.off + this.calc_text_width(this.display[i + this.offset].name, this.fonts_playlist) + 5, this.ylist + this.layerUp + (i * this.row_height) + 5, 15, this.row_height);    //25 a revoir
                }
                // playlist statistics
                gr.WriteText(disp, this.fonts_playlist, col, this.w - this.calc_text_width(disp, this.fonts_playlist) - 4, this.ylist + this.layerUp + (i * this.row_height), this.calc_text_width(disp, this.fonts_playlist) + 20, this.row_height);
                col = this.text_color;
            }
            // paint the active playlist
            if (plman.ActivePlaylist != -1) {
                if (plman.FindPlaylist(this.display[i + this.offset].name) == plman.ActivePlaylist)
                    gr.DrawRectangle(this.off - 4, this.ylist + this.layerUp + (i * this.row_height) + 1, this.w - this.off + 7, this.row_height + 0, 1, this.but_color); // -4 & +1 are there to hide the rectangle when selected
            }
        }

        if (selected.index > -1) {
            var indent = this.display[selected.index].lvl * 23;

            if (this.display[selected.index].pl == 0) { //paint a selected folder
                var fold = this.display[selected.index].name;
                fold_numbers = this.data.filter(function (artr) { //count of playlists in that folder (from this.data because display have excluded them)
                    return artr.fold == fold;
                }).length;
                var disp = _formatNumber(this.display[selected.index].value, this.thousandSeparator); //.toString().replace(/\B(?=(\d{3})+(?!\d))/g, " ");
                var fold = (this.display[selected.index].foldState == '1' ? folderIcon[this.folderIcon].open : folderIcon[this.folderIcon].close);
                var font = this.foldertext_weight == 1 ? this.fonts_folder_bold : this.fonts_folder;
                gr.fillrectangle(this.off - 5, this.ylist + this.layerUp + ((selected.index - this.offset) * this.row_height), this.w - this.off + 8, this.row_height + 2, this.selection_color);
                gr.WriteText(fold, this.fonts.awesome, this.folderIcon_color, indent + this.off, this.ylist + this.layerUp + ((selected.index - this.offset) * this.row_height) + 5, this.panel_w, this.row_height);
                gr.WriteText(" " + this.display[selected.index].name + " [" + fold_numbers + "]", font, this.folder_color, indent + this.off + this.calc_text_width(fold, font) + 5, this.ylist + this.layerUp + ((selected.index - this.offset) * this.row_height), this.panel_w, this.row_height);
                gr.WriteText(disp, font, this.folder_color, this.w - this.calc_text_width(disp, font) - 4, this.ylist + this.layerUp + ((selected.index - this.offset) * this.row_height), this.panel_w, this.row_height);
            }
            else { // paint a selected pl
                switch (this.displayStats) {
                    case 0:
                        disp = _formatNumber(this.display[selected.index].value, this.thousandSeparator);
                        break;
                    case 1:
                        disp = niceBytes(this.display[selected.index].size);
                        break;
                    case 2:
                        disp = "#" + _formatNumber(this.display[selected.index].value, this.thousandSeparator) + " | " + niceBytes(this.display[selected.index].size);
                        break;
                    case 3:
                        disp = millisecondsToStr(plman.GetPlaylistItems(plman.FindByGUID(this.display[selected.index].id)).CalcTotalDuration())
                        break;
                }
                // if (this.displayStats == 0)
                //    disp = _formatNumber(this.display[selected.index].value, this.thousandSeparator);
                // else disp = "#" + _formatNumber(this.display[selected.index].value, this.thousandSeparator) + " | " + niceBytes(this.display[selected.index].size);
                if (playing_item_location.IsValid) { // file played
                    if (this.display[selected.index].name == plman.GetPlaylistName(playing_item_location.PlaylistIndex) && this.activeSongOption == 0)
                        col = this.activeSong_color;
                    else col = this.text_color;
                }
                var dispIndex = selected.index - this.offset;
                switch (true) {
                    case (dispIndex < 0):
                        dispIndex = -4;
                        break;
                    case (dispIndex >= this.rows):
                        dispIndex = this.rows + 4;
                        break;
                }
                gr.fillrectangle(this.off - 5, this.ylist + this.layerUp + (dispIndex * this.row_height), this.w - this.off + 8, this.row_height + 2, this.selection_color);

                // selected playlist name
                gr.WriteText(this.display[selected.index].name, this.fonts_playlist, col, indent + this.nodeIndent + this.off, this.ylist + this.layerUp + (dispIndex * this.row_height), this.panel_w - (this.calc_text_width(disp, this.fonts) + indent + this.off) - 35, this.row_height);
                var plId = plman.FindByGUID(this.display[selected.index].id);
                if ((!playlist_can_remove(plId) || !playlist_can_add(plId) || !playlist_can_rename(plId)) && this.lockStatus == 1) {
                    gr.WriteText(chars["locked"], this.fonts.awesome, col, indent + this.nodeIndent + this.off + this.calc_text_width(this.display[selected.index].name, this.fonts_playlist) + 5, this.ylist + this.layerUp + (dispIndex * this.row_height) + 5, 15, this.row_height);   //25 a revoir
                }
                gr.WriteText(disp, this.fonts_playlist, col, this.w - this.calc_text_width(disp, this.fonts_playlist) - 4, this.ylist + this.layerUp + (dispIndex * this.row_height), this.calc_text_width(disp, this.fonts_playlist) + 20, this.row_height);
            }
        }
        if (this.dragDrop) { //if drag & drop
            gr.DrawRectangle(30, this.DragLineY, this.w - 25, this.DragLineH, 2, RGB(255, 0, 0));
        }
        if (this.inputboxID == 1) this.inputbox.draw(gr, (this.w / 2) - (100 / 2), 0);
        if (!(p_scrollbar.w > 0)) {
            p_scrollbar.setSize(this.panel_w - cScrollBar.width, this.ylist, cScrollBar.width, this.h);
            p_scrollbar.setCursor(this.rows, this.items, this.offset);
        }
        if (p_scrollbar.visible) {
            p_scrollbar.draw(gr);
        }
        if (this.middleButtonPressed) {
            gr.DrawLine(0, this.middleButtonY, this.w, this.middleButtonY, 0.5, RGB(255, 255, 255));
        }
    }

    this.containsXY = function (x, y) {
        return x > this.off && x < this.w && y > this.y && y < this.panel_h;
    }

    this.wheel = function (s) {
        if (this.items > this.rows) {
            var offset = Math.round(this.offset - (s * this.mouseScrollSpeed_value)); // mouse scroll speed
            if (offset < 0) {
                offset = 0;
            }
            if (offset + this.rows > this.items) {
                offset = this.items - this.rows;
            }
            if (this.offset != offset) {
                this.offset = offset;
                window.Repaint();
            }
        }
        else this.offset = 0;
        p_scrollbar.setCursor(this.rows, this.items, this.offset);
        return true;
    }

    this.lbtn_dblck = function (x, y) {
        if (this.containsXY(x, y)) {
            switch (true) {
                case !this.in_range:
                    break;
                // BELOW TO Double CLICK ON AN ITEM
                case x > this.off && x < this.panel_w:
                    if (this.display[this.index].pl == 0) {//folder
                        if (this.display[this.index].foldState == '1') this.display[this.index].foldState = '0';
                        else {
                            if (this.autocollapse && this.display[this.index].lvl == '0') {
                                for (var i = 0; i < this.data.length; i++) {
                                    if (this.data[i].foldState == '1' && this.data[i].lvl == '0') this.data[i].foldState = '0';
                                }
                            }
                            this.display[this.index].foldState = '1';
                        }
                    }
                    else {
                        plman.ActivePlaylist = plman.FindPlaylist(this.display[this.index].name);
                        if (plman.GetPlaylistItemCount(plman.ActivePlaylist) > 0)
                            if (this.dblCkPlaySong) plman.ExecutePlaylistDefaultAction(plman.ActivePlaylist, 0);
                    }
                    this.cleanup();
                    this.setSel(this.index);
                    this.wheel(0);
                    window.Repaint();
                    break;
            }
            return true;
        }
        return false;
    }

    this.move = function (x, y) {
        window.SetCursor(IDC_ARROW);
        p_scrollbar.check("move", x, y);

        if (this.containsXY(x, y)) {
            this.index = Math.floor((y - this.ylist - this.layerUp) / this.row_height) + this.offset;
            if (this.index >= this.items) this.index = -1;
            this.in_range = this.index >= this.offset && this.index < this.offset + Math.min(this.rows, this.items);
            switch (true) {
                case !this.in_range:
                    break;
                case x > this.off && x < this.w:
                    window.SetCursor(IDC_HAND);
                    if (this.btnDown && Math.abs(this.dragy - y) > 2) {
                        if (this.index + 1 - this.offset == this.rows) this.offset = Math.min(this.offset + 1, (this.items - this.rows)); // boundary down
                        if (this.index - this.offset == 0) this.offset = Math.max(this.offset - 1, 0);  // boundary up
                        var to = (this.row_height * (this.index - this.offset + 1)) + this.ylist + this.layerUp;
                        var from = to - this.row_height;
                        window.SetCursor(IDC_HELP);
                        switch (true) {
                            case y >= from && y < from + 7:
                                window.SetCursor(IDC_HAND);
                                this.dragDrop = true;
                                this.DragLineY = from;
                                this.DragLineH = 0;
                                _tt("Dragging " + this.display[this.draggedIndex].name + " before " + this.display[this.index].name);
                                if (this.draggedIndex < this.droppedIndex) this.droppedIndex = this.index - 1; else this.droppedIndex = this.index;
                                break;
                            case y < to && y > to - 7:
                                window.SetCursor(IDC_HAND);
                                this.dragDrop = true;
                                this.DragLineY = to;
                                this.DragLineH = 0;
                                _tt("Dragging " + this.display[this.draggedIndex].name + " after " + this.display[this.index].name); // ?
                                if (this.draggedIndex < this.droppedIndex) this.droppedIndex = this.index; else this.droppedIndex = this.index + 1;
                                break;
                            case y > from + 7 && y < to - 7 && this.display[this.index].pl == '0' && this.display[this.index].id !== this.display[this.draggedIndex].id:
                                window.SetCursor(IDC_HAND);
                                this.dragDrop = true;
                                this.DragLineY = from;
                                this.DragLineH = this.row_height;
                                _tt("Dropping " + this.display[this.draggedIndex].name + " in the folder " + this.display[this.index].name); // ?
                                this.droppedIndex = this.index;
                                break;
                            default:
                                this.dragDrop = false;
                                _tt('');
                                break;
                        }
                        window.repaint();
                    }
                    if (this.middleButtonPressed) {
                        window.SetCursor(IDC_SIZENS);
                        var ecart = this.middleButtonY - y;
                        var speed = ecart / this.h * 100 / 10;
                        this.wheel(1 * speed);
                    }

                    if (x > (this.w - (this.displayStats == 0 ? 80 : 120)))
                        this.display[this.index].pl == 1 ? _tt('Duration: ' + millisecondsToStr(plman.GetPlaylistItems(plman.FindByGUID(this.display[this.index].id)).CalcTotalDuration())) : _tt('');
                    else if (this.truncedId.indexOf(this.display[this.index].id) >= 0)
                        _tt(this.display[this.index].name);
                    else
                        _tt('');
                    break;

            }
            return true;
        }
        return false;
    }
    this.lbtn_down = function (x, y) {
        p_scrollbar.check("lbtn_down", x, y);
        if (this.containsXY(x, y)) {
            this.dragy = y;
            this.btnDown = true;
        }
        if (this.containsXY(x, y)) {
            switch (true) {
                case !this.in_range:
                    break;
                case x > this.off && x < this.panel_w:
                    this.draggedIndex = this.index;
                    break;
            }
            return true;
        }
        return false;
    }

    this.lbtn_up = function (x, y) {
        // for (y = 0; y < this.display.length; y++)
        p_scrollbar.check("lbtn_up", x, y);
        this.btnDown = false;
        if (this.dragDrop) {
            indexDrop = _.findIndex(this.data, { id: this.display[this.droppedIndex].id });
            id = this.display[this.draggedIndex].id;
            indexDrag = _.findIndex(this.data, { id: id });
            if (this.DragLineH == 0) { // not a folder
                if (this.display[this.draggedIndex].lvl != this.display[this.droppedIndex].lvl) {
                    this.data[indexDrag].fold = this.display[this.droppedIndex].fold;
                    this.data[indexDrag].lvl = this.display[this.droppedIndex].lvl;
                }
                this.data.move(_.findIndex(this.data, { id: this.display[this.draggedIndex].id }), _.findIndex(this.data, { id: this.display[this.droppedIndex].id }));
            }
            else { //a folder
                this.data[indexDrag].fold = this.data[indexDrop].name;
                this.data[indexDrag].lvl = Number(this.data[indexDrop].lvl) + 1;
            }
            idDrop = this.data[indexDrop].id;
            this.dragDrop = false;
            this.countFold();
            this.cleanup();
            idDrop = _.findIndex(this.display, { id: idDrop });
            if (this.display[idDrop].foldState == '0') {
                this.setSel(idDrop);
            }
            else {
                this.setSel(_.findIndex(this.display, { id: id }));
            }
            this.wheel(0);
            window.repaint();
        }
        else {
            if (this.containsXY(x, y)) {
                switch (true) {
                    case !this.in_range:
                        break;
                    case x > this.off && x < this.off + 22 + (22 * (this.display[this.index].lvl)) && this.display[this.index].pl == 0:
                        if (this.display[this.index].foldState == '1') this.display[this.index].foldState = '0';
                        else {
                            if (this.autocollapse && this.display[this.index].lvl == '0') {
                                for (var i = 0; i < this.data.length; i++) {
                                    if (this.data[i].foldState == '1' && this.data[i].lvl == '0') this.data[i].foldState = '0';
                                }
                            }
                            this.display[this.index].foldState = '1';
                        }
                        this.cleanup();
                        this.setSel(this.index);
                        this.wheel(0);
                        window.repaint();
                        break;
                    case x > this.off && x < this.panel_w: // TO CLICK ON AN ITEM
                        if (this.index == selected.index)
                            selected.index = -1;
                        else {
                            if (this.openPLclick == 0 && this.display[this.index].pl == 1) {
                                plman.ActivePlaylist = plman.FindByGUID(this.display[this.index].id);
                            }
                            this.cleanup();
                            this.setSel(this.index);
                        }
                        this.wheel(0);
                        //                      window.Repaint();
                        window.RepaintRect(0, this.ylist, this.panel_w, this.h);
                        break;
                }
                return true;
            }
        }
        return false;
    }
    this.on_drag_over = function (action, x, y, mask) {
        if (this.containsXY(x, y)) {
            this.index = Math.floor((y - this.ylist - this.layerUp) / this.row_height) + this.offset;
            this.in_range = this.index >= this.offset && this.index < this.offset + Math.min(this.rows, this.items);
            switch (true) {
                case !this.in_range:
                    break;
                case x > this.off && x < this.panel_w:
                    if (this.display[this.index].pl == 1 && !plman.IsAutoPlaylist(plman.FindByGUID(this.display[this.index].id)) && playlist_can_add(plman.FindByGUID(this.display[this.index].id))) {
                        action.Effect = 1;
                    }
                    else
                        action.Effect = 0;
            }
        }
    }
    this.on_drag_drop = function (action, x, y, mask) {
        if (this.containsXY(x, y)) {
            this.index = Math.floor((y - this.ylist - this.layerUp) / this.row_height) + this.offset;
            this.in_range = this.index >= this.offset && this.index < this.offset + Math.min(this.rows, this.items);
            switch (true) {
                case !this.in_range:
                    console.log(this.in_range);
                    //create new playlist
                    //var new_index = plman.CreatePlaylist(plman.PlaylistCount, "test");
                    var new_index = plman.CreatePlaylist();
                    plman.ActivePlaylist = new_index;
                    //populate
                    action.Playlist = new_index;
                    action.Base = plman.GetPlaylistItemCount(new_index);
                    action.ToSelect = true;
                    action.Effect = 1;
                    window.repaint();
                    break;
                case x > this.off && x < this.panel_w:
                    if (this.display[this.index].pl == 1 && !plman.IsAutoPlaylist(plman.FindByGUID(this.display[this.index].id))) {
                        var ap = plman.FindByGUID(this.display[this.index].id);
                        action.Playlist = ap;
                        action.Base = plman.GetPlaylistItemCount(ap);
                        action.ToSelect = true;
                        action.Effect = 1;
                        window.repaint();
                    }
                    break;
            }
        }
    }

    this.PLmgt = function (i) {

        var id = _.findIndex(this.data, { id: plman.GetGUID(i) })
        this.data[id].value = plman.GetPlaylistItemCount(i);
        this.data[id].size = plman.GetPlaylistItems(i).CalcTotalSize();
        window.repaint();
    }

    this.rbtn_up = function (x, y) {
        if (this.containsXY(x, y)) {
            switch (true) {
                case x > this.off && x < this.panel_w && y > 0:
                    if (this.index > -1) this.setSel(this.index);
                    window.repaint();
                    this.contextMenu(x, y);
                    break;
            }
            return true;
        }
        return false;
    }
    this.mbtn_down = function (x, y) {
        this.middleButtonPressed = true;
        this.middleButtonY = y;
        window.repaint();
    }
    this.mbtn_up = function (x, y) {
        this.middleButtonPressed = false;
        window.repaint();
    }

    this.contextMenu = function (x, y) {

        this.s = window.CreatePopupMenu();
        this.l1 = window.CreatePopupMenu();
        this.l3 = window.CreatePopupMenu();
        this.l7 = window.CreatePopupMenu();
        this.l10 = window.CreatePopupMenu();
        this.l11 = window.CreatePopupMenu();
        this.l13 = window.CreatePopupMenu();
        this.l14 = window.CreatePopupMenu();
        this.l15 = window.CreatePopupMenu();
        this.l16 = window.CreatePopupMenu();
        this.l17 = window.CreatePopupMenu();
        this.l18 = window.CreatePopupMenu();
        this.menuAppearance = window.CreatePopupMenu();
        this.menuColors = window.CreatePopupMenu();
        this.menuContextSettings = window.CreatePopupMenu();
        this.menuCreate = window.CreatePopupMenu();
        this.menuFolders = window.CreatePopupMenu();
        this.menuHelp = window.CreatePopupMenu();
        this.menuIcons = window.CreatePopupMenu();
        this.menuKeyboard = window.CreatePopupMenu();
        this.menuMouse = window.CreatePopupMenu();
        this.menuMouseScrolling = window.CreatePopupMenu();
        this.menuMove = window.CreatePopupMenu();
        this.menuRestore = window.CreatePopupMenu();
        this.menuSettings = window.CreatePopupMenu();
        this.menuSort = window.CreatePopupMenu();
        this.menuText = window.CreatePopupMenu();
        this.menuTextColors = window.CreatePopupMenu();
        this.ScrollMenu = window.CreatePopupMenu();
        this.opacitybkMenu = window.CreatePopupMenu();
        this.themeMgt = window.CreatePopupMenu();

        // Move up/down
        if (this.contextMoveUpDown == 1) {
            this.s.AppendMenuItem(EnableMenuIf(selected.index > -1), 1200, 'Move up \t-');
            this.s.AppendMenuItem(EnableMenuIf(selected.index > -1), 1250, 'Move down\t+');
            this.s.AppendMenuSeparator();
        }

        if (selected.index > -1) plId = plman.FindByGUID(this.display[selected.index].id);
        // Create
        this.menuCreate.AppendTo(this.s, MF_STRING, 'Create');
        this.menuCreate.AppendMenuItem(EnableMenuIf(selected.index > -1), 1500, 'Create folder...');
        this.menuCreate.AppendMenuItem(MF_STRING, 1600, 'Create autoplaylist...');
        this.menuCreate.AppendMenuItem(MF_STRING, 1630, 'Create playlist...');

        // Delete
        // this.s.AppendMenuItem(EnableMenuIf(selected.index > -1 && selected.pl == 1 ? playlist_can_remove(plman.FindByGUID(this.display[selected.index].id)) : true), 1700, 'Delete ' + (selected.pl == 1 ? 'playlist' : 'folder') + '\tDel');
        this.s.AppendMenuItem(EnableMenuIf(selected.index > -1 && selected.pl == 1 ? playlist_can_remove(plId) : true), 1700, 'Delete ' + (selected.pl == 1 ? 'playlist' : 'folder') + (this.delOption == 1 ? '\tDel' : ''));

        // Move menu
        this.menuMove.AppendTo(this.s, EnableMenuIf(selected.index > -1 && selected.pl == 1), 'Move to');
        this.menuMove.AppendMenuItem(EnableMenuIf(selected.index > -1 && this.display[selected.index].lvl > 0 && selected.pl == 1), 1800, '<Root>');
        this.ctrl ? this.Folder = this.data.filter(function (artr) {
            return artr.pl == '0' && artr.lvl == '0';
        }) : this.Folder = this.data.filter(function (artr) {
            return artr.pl == '0';
        });
        if (this.Folder.length) {
            this.menuMove.AppendMenuSeparator();
            for (var i = 0; i < this.Folder.length; i++) {
                arr = [];
                for (var j = 0; j < this.Folder.length; j++) {
                    if (this.Folder[j].fold == this.Folder[i].name && this.Folder[j].lvl == '1')
                        arr.push(this.Folder[j]);
                }
                if (arr.length) {
                    this["menu" + j] = window.CreatePopupMenu(); // how to dispose these menus ?
                    this["menu" + j].AppendTo(this.menuMove, MF_STRING, this.Folder[i].name);
                    for (var k = 0; k < arr.length; k++) {
                        this["menu" + j].AppendMenuItem(MF_STRING, _.findIndex(this.data, { id: arr[k].id }) + 2000, arr[k].name);
                    }
                }
                else if (this.Folder[i].lvl == '0') { this.menuMove.AppendMenuItem(MF_STRING, _.findIndex(this.data, { id: this.Folder[i].id }) + 2000, this.Folder[i].name); }
            }
        }

        // Rename
        this.s.AppendMenuItem(EnableMenuIf(selected.index > -1 && selected.pl == 1 ? playlist_can_rename(plId) : true), 1400, 'Rename ' + (selected.pl == 1 ? 'playlist...' : 'folder...') + '\tF2');

        // Sort folders
        var filt = "";
        if (selected.index > -1) {
            if (selected.pl == 1) filt = this.display[selected.index].fold;
            else filt = this.display[selected.index].name;
        }
        this.menuSort.AppendTo(this.s, EnableMenuIf(selected.index > -1), 'Sort folder');
        this.menuSort.AppendMenuItem(MF_GRAYED, 0, (filt == "" ? 'Root' : filt));
        this.menuSort.AppendMenuSeparator();
        this.menuSort.AppendMenuItem(EnableMenuIf(selected.index > -1), 1450, 'Ascending order');
        this.menuSort.AppendMenuItem(EnableMenuIf(selected.index > -1), 1460, 'Descending order');

        // Playlist related items
        if (selected.pl == 1 && selected.index > -1 && plman.IsAutoPlaylist(plId)) {
            this.s.AppendMenuSeparator();
            this.s.AppendMenuItem(MF_STRING, 1300, 'Edit autoplaylist...');
            this.s.AppendMenuItem(MF_STRING, 166, "Convert to standard playlist");
        }
        else if (selected.pl == 1 && selected.index > -1) {
            this.s.AppendMenuSeparator();
            var lock_name = plman.GetPlaylistLockName(plId);
            var is_locked = plman.IsPlaylistLocked(plId);
            var is_mine = lock_name == "JScript Panel 3";
            this.s.AppendMenuItem(EnableMenuIf(is_mine || !is_locked), 1795, "Edit playlist lock...");
            this.s.AppendMenuItem(EnableMenuIf(is_mine), 1796, "Remove playlist lock");
        }

        // Contents
        if (selected.index > -1) {
            var playlist_items = plman.GetPlaylistItems(plId);
            if (playlist_items.Count > 0) {
                this.s.AppendMenuSeparator();
            }
            this._items = window.CreatePopupMenu();
            this._context = fb.CreateContextMenuManager();
            if (playlist_items.Count > 0) {
                this._context.InitContext(playlist_items);
                this._context.BuildMenu(this._items, 10000);
                this._items.AppendTo(this.s, MF_STRING, 'Contents');
            }
        }
        this.s.AppendMenuSeparator();

        // Restore
        var count = plman.RecyclerCount;
        this.menuRestore.AppendTo(this.s, EnableMenuIf(count > 0), 'Restore');
        if (count > 0)
            for (var j = 0; j < count; j++)
                this.menuRestore.AppendMenuItem(MF_STRING, j + 1 + 1700, plman.GetRecyclerName(j));
        this.menuRestore.AppendMenuSeparator();
        this.menuRestore.AppendMenuItem(EnableMenuIf(count > 0), 1791, 'Purge deleted playlists');

        // Theme management
        if (this.themeChoosen >= 0) themeName = this.themeData[this.themeChoosen].name; else themeName = "None Choosen";
        this.themeMgt.AppendTo(this.s, MF_STRING, 'Theme');
        this.themeMgt.AppendMenuItem(MF_GRAYED, 0, themeName);
        this.themeMgt.AppendMenuSeparator();
        this.themeMgt.AppendMenuItem(EnableMenuIf(this.themeData.length <= 9), 801, 'Create ...'); // can only create 10 themes

        this.l15.AppendTo(this.themeMgt, MF_STRING, 'Choose');
        for (var i = 0; i < this.themeData.length; i++)
            this.l15.AppendMenuItem(MF_STRING, i + 805, this.themeData[i].name);
        if (this.themeChoosen >= 0) this.l15.CheckMenuRadioItem(805, 814, this.themeChoosen + 805);

        this.l16.AppendTo(this.themeMgt, MF_STRING, 'Update');
        for (var i = 0; i < this.themeData.length; i++)
            this.l16.AppendMenuItem(MF_STRING, i + 815, this.themeData[i].name);

        //this.themeMgt.AppendMenuItem(MF_STRING, 802, 'Update'); //mettre le nom de l'encours
        this.l17.AppendTo(this.themeMgt, MF_STRING, 'Rename');
        for (var i = 0; i < this.themeData.length; i++)
            this.l17.AppendMenuItem(MF_STRING, i + 825, this.themeData[i].name);

        //this.themeMgt.AppendMenuItem(EnableMenuIf(this.themeChoosen > -1), 803, 'Rename'); //mettre le nom de l'encours
        this.l18.AppendTo(this.themeMgt, MF_STRING, 'Delete');
        for (var i = 0; i < this.themeData.length; i++)
            this.l18.AppendMenuItem(MF_STRING, i + 835, this.themeData[i].name);

        //this.themeMgt.AppendMenuItem(EnableMenuIf(this.themeChoosen > -1), 804, 'Delete'); //mettre le nom de l'encours


        // Settings menu
        this.menuSettings.AppendTo(this.s, MF_STRING, 'Settings');

        // Appearance menu
        this.menuAppearance.AppendTo(this.menuSettings, MF_STRING, 'Appearance');

        // Colors and font menu
        this.menuColors.AppendTo(this.menuAppearance, MF_STRING, 'Colors and font');

        this.l1.AppendTo(this.menuColors, MF_STRING, 'Background');
        this.l1.AppendMenuItem(CheckMenuIf(this.bgpic), 1060, 'Set background to front cover');
        this.l1.AppendMenuItem(EnableMenuIf(this.bgpic), 1063, 'Front cover Stretched');
        this.l1.AppendMenuItem(EnableMenuIf(this.bgpic), 1064, 'Front cover Centered');
        this.l1.CheckMenuRadioItem(1063, 1064, this.BGaspect_value + 1061);
        this.opacitybkMenu.AppendTo(this.l1, MF_STRING, 'Opacity %');
        _.forEach(this.opacity_perc, function (item) {
            this.opacitybkMenu.AppendMenuItem(MF_STRING, Number(item) + 100, item);
        }, this);
        this.opacitybkMenu.CheckMenuRadioItem(Number(_.first(this.opacity_perc)) + 100, Number(_.last(this.opacity_perc)) + 100, Number(this.opacity_perc_value));
        this.l1.AppendMenuSeparator();
        this.l1.AppendMenuItem(CheckMenuIf(!this.bgpic), 1061, 'Set background to color...');
        this.l1.AppendMenuItem(MF_STRING, 1062, 'Reset');

        this.l3.AppendTo(this.menuColors, MF_STRING, 'Selection bar');
        this.l3.AppendMenuItem(MF_STRING, 1088, 'Selection bar color...');
        this.l3.AppendMenuItem(MF_STRING, 1089, 'Reset');

        this.menuColors.AppendMenuItem(MF_STRING, 1075, 'Header seperator color...');

        this.menuTextColors.AppendTo(this.menuColors, MF_STRING, 'Text');
        this.menuTextColors.AppendMenuItem(MF_STRING, 1082, 'Folder color...');
        this.menuTextColors.AppendMenuItem(this.foldertext_weight == 1 ? MF_CHECKED : MF_UNCHECKED, 1086, 'Bold folder text');
        this.menuTextColors.AppendMenuSeparator();
        this.menuTextColors.AppendMenuItem(MF_STRING, 1081, 'Playlist color...');
        this.menuTextColors.AppendMenuItem(MF_STRING, 1098, 'Active playlist color...');
        this.menuTextColors.AppendMenuSeparator();
        this.menuTextColors.AppendMenuItem(MF_STRING, 1083, 'Reset');

        // Font size menu
        this.menuColors.AppendMenuSeparator();
        this.menuText.AppendTo(this.menuColors, MF_STRING, 'Font size');
        if (this.list_objects.length || this.text_objects.length) {
            _.forEach(this.fonts_sizes, function (item) {
                this.menuText.AppendMenuItem(MF_STRING, item, item);
            }, this);
            this.menuText.CheckMenuRadioItem(_.first(this.fonts_sizes), _.last(this.fonts_sizes), this.fontSize_value);
        }

        // Context (settings) menu
        this.menuContextSettings.AppendTo(this.menuAppearance, MF_STRING, 'Context menu');
        this.menuContextSettings.AppendMenuItem(this.contextMoveUpDown == 1 ? MF_CHECKED : MF_UNCHECKED, 1096, 'Show Move Up/Down items');

        // Icons menu
        this.menuIcons.AppendTo(this.menuAppearance, MF_STRING, 'Icons');

        this.l7.AppendTo(this.menuIcons, MF_STRING, 'Playback status');
        this.l7.AppendMenuItem(this.activeSongOption == 1 ? MF_CHECKED : MF_UNCHECKED, 1099, 'Show icon');
        this.l7.AppendMenuItem((this.activeSongOption == 0 ? MF_GRAYED : MF_STRING), 1070, 'Set color...');

        this.menuFolders.AppendTo(this.menuIcons, MF_STRING, 'Folders');
        this.menuFolders.AppendMenuItem(MF_STRING, 1160, "Folder icon");
        this.menuFolders.AppendMenuItem(MF_STRING, 1161, "Carets icon");
        this.menuFolders.CheckMenuRadioItem(1160, 1161, this.folderIcon + 1160);
        this.menuFolders.AppendMenuSeparator();
        this.menuFolders.AppendMenuItem(MF_STRING, 1084, 'Set icon color ...');
        this.menuFolders.AppendMenuItem(MF_STRING, 1085, 'Reset');

        this.ScrollMenu.AppendTo(this.menuAppearance, MF_STRING, 'Scrollbar');
        this.l14.AppendTo(this.ScrollMenu, MF_STRING, 'Size');
        this.l14.AppendMenuItem(MF_STRING, 1165, 'Small');
        this.l14.AppendMenuItem(MF_STRING, 1166, 'Medium');
        this.l14.AppendMenuItem(MF_STRING, 1167, 'Big');
        this.l14.AppendMenuItem(MF_STRING, 1168, 'Very Big');
        this.l14.CheckMenuRadioItem(1165, 1168, this.scrollWidth + 1165);
        this.ScrollMenu.AppendMenuItem(MF_STRING, 1268, 'Set Color ...');
        this.ScrollMenu.AppendMenuItem(MF_STRING, 1269, 'Set default Color');

        this.menuAppearance.AppendMenuItem(this.nodeIndent == 0 ? MF_UNCHECKED : MF_CHECKED, 1198, 'Indent playlist nodes');

        this.l13.AppendTo(this.menuAppearance, MF_STRING, 'Playlist stats');
        this.l13.AppendMenuItem(MF_STRING, 1170, 'Item count');
        this.l13.AppendMenuItem(MF_STRING, 1171, 'Item size');
        this.l13.AppendMenuItem(MF_STRING, 1172, 'Item count and size');
        this.l13.AppendMenuItem(MF_STRING, 1173, 'Item duration');
        this.l13.CheckMenuRadioItem(1170, 1173, this.displayStats + 1170);
        this.l13.AppendMenuSeparator();

        this.l11.AppendTo(this.l13, MF_STRING, 'Thousands separator');
        this.l11.AppendMenuItem(MF_STRING, 1150, 'None');
        this.l11.AppendMenuItem(MF_STRING, 1151, 'Space');
        this.l11.AppendMenuItem(MF_STRING, 1152, '.');
        this.l11.AppendMenuItem(MF_STRING, 1153, ',');
        this.l11.CheckMenuRadioItem(1150, 1153, Separator.indexOf(this.thousandSeparator) + 1150);

        this.menuAppearance.AppendMenuItem(this.header == 1 ? MF_CHECKED : MF_UNCHECKED, 1068, 'Show header');
        this.menuAppearance.AppendMenuItem(this.lockStatus == 1 ? MF_CHECKED : MF_UNCHECKED, 1197, 'Show lock status');
        this.menuSettings.AppendMenuItem(CheckMenuIf(this.autocollapse), 1050, 'Auto-collapse folders');

        // Keyboard shortcuts menu
        this.menuKeyboard.AppendTo(this.menuSettings, MF_STRING, 'Keyboard shortcuts');
        this.menuKeyboard.AppendMenuItem(this.delOption == 1 ? MF_CHECKED : MF_UNCHECKED, 1095, 'Enable <Delete> key');

        // Mouse behavior menu
        this.menuMouse.AppendTo(this.menuSettings, MF_STRING, 'Mouse behavior');
        this.menuMouse.AppendMenuItem(this.openPLclick == 1 ? MF_CHECKED : MF_UNCHECKED, 1091, 'Open playlist on double-click');
        this.menuMouse.AppendMenuItem(this.dblCkPlaySong == 1 ? MF_CHECKED : MF_UNCHECKED, 1093, 'Play track on double-click');
        // Mouse scroll speed menu
        this.menuMouseScrolling.AppendTo(this.menuMouse, MF_STRING, 'Scroll speed');
        this.menuMouseScrolling.AppendMenuItem(MF_STRING, 1179, 'Fast');
        this.menuMouseScrolling.AppendMenuItem(MF_STRING, 1178, 'Medium');
        this.menuMouseScrolling.AppendMenuItem(MF_STRING, 1177, 'Slow');
        this.menuMouseScrolling.CheckMenuRadioItem(1177, 1179, this.mouseScrollSpeed_value + 1176);
        this.menuMouseScrolling.AppendMenuSeparator();
        this.menuMouseScrolling.AppendMenuItem(MF_STRING, 1179, 'Reset');

        this.menuSettings.AppendMenuSeparator();
        this.l10.AppendTo(this.menuSettings, MF_STRING, 'Backup folder structure');
        this.l10.AppendMenuItem(MF_STRING, 1100, 'Create backup');
        this.l10.AppendMenuItem(EnableMenuIf(archiveFileStatus), 1101, 'Restore backup');
        this.menuSettings.AppendMenuItem(MF_STRING, 2000, 'Configure...');

        // Help menu
        this.menuHelp.AppendTo(this.s, MF_STRING, 'Help');
        this.menuHelp.AppendMenuItem(MF_GRAYED, 0, 'Total playlists: ' + this.data.filter(function (artr) { return artr.pl == 1; }).length);
        this.menuHelp.AppendMenuSeparator();
        this.menuHelp.AppendMenuItem(MF_STRING, 1191, 'Discussion thread');
        this.menuHelp.AppendMenuItem(MF_STRING, 1190, 'Reference manual');

        var idx = this.s.TrackPopupMenu(x, y);
        switch (true) {
            case idx <= 32 && idx > 0:
                this.fontSize_value = idx;
                window.SetTooltipFont('Segoe UI', _scale(idx));
                this.font_changed();
                this.size();
                window.SetProperty("PL.FONTSIZE.VALUE", this.fontSize_value);
                window.Repaint();
                break;
            case idx <= 200 && idx > 100:
                this.opacity_perc_value = idx;
                window.SetProperty("PL.BACKGROUNDPIC.OPACITY", this.opacity_perc_value);
                window.Repaint();
                break;
            case idx == 801:  //theme create theme from current
                //   if (this.themeData.length <= 9) {
                try {
                    name = utils.InputBox("Input name of the new theme", "Create a new theme", "New theme", true);
                    if (name) {
                        // check if name already exist
                        var ind = _.findIndex(this.themeData, { "name": name });
                        if (ind != -1) { utils.MessageBox("you entered a name that already exist, use Update if you want to update this theme", "Duplicate name", MB_OK | MB_ICONEXCLAMATION) }
                        else {
                            if (themeFileStatus == false) utils.WriteTextFile(themeFile, "");
                            this.pushTheme(name);
                            this.themeChoosen = this.themeData.length - 1;
                            this.save_status(themeFile, this.themeData)
                        }

                    }
                } catch (e) { return; }
                //   }
                //   else
                //       utils.MessageBox("Number of themes limited to 10", "# of themes exceeded", MB_OK | MB_ICONEXCLAMATION);
                break;
            case idx <= 814 && idx >= 805:
                //       if (this.themeChoosen == (idx - 805)) this.themeChoosen = -1;
                //       else {
                this.themeChoosen = idx - 805;
                this.restoreTheme();
                //     }
                window.SetProperty("PL.THEME.NUMBER", this.themeChoosen);
                this.size();
                window.Repaint();
                break;
            case idx <= 824 && idx >= 815: //update
                var themeId = idx - 815;
                this.themeData[themeId].this_autocollapse = this.autocollapse;
                this.themeData[themeId].this_bgpic = this.bgpic;
                this.themeData[themeId].this_but_color = this.but_color;
                this.themeData[themeId].this_colours_background = this.colours_background;
                this.themeData[themeId].this_colours_highlight = this.colours_highlight;
                this.themeData[themeId].this_folder_color = this.folder_color;
                this.themeData[themeId].this_fontSize_value = this.fontSize_value;
                this.themeData[themeId].this_selection_color = this.selection_color;
                this.themeData[themeId].this_text_color = this.text_color;
                this.themeData[themeId].this_activeSongOption = this.activeSongOption;
                this.themeData[themeId].this_activeSong_color = this.activeSong_color;
                this.themeData[themeId].this_folderIcon_color = this.folderIcon_color;
                this.themeData[themeId].this_foldertext_weight = this.foldertext_weight;
                this.themeData[themeId].this_headerline_color = this.headerline_color;
                this.themeData[themeId].this_thousandSeparator = this.thousandSeparator;
                this.themeData[themeId].this_folderIcon = this.folderIcon;
                this.themeData[themeId].this_displayStats = this.displayStats;
                this.themeData[themeId].this_header = this.header;
                this.themeData[themeId].this_scrollWidth = this.scrollWidth;
                this.themeData[themeId].this_scrollColor = this.scrollColor;
                this.themeData[themeId].this_opacity_perc_value = this.opacity_perc_value;
                this.themeData[themeId].this_BGaspect_value = this.BGaspect_value;
                this.themeData[themeId].this_nodeIndent = this.nodeIndent;
                this.save_status(themeFile, this.themeData)
                break;
            case idx <= 834 && idx >= 825: //rename
                var themeId = idx - 825;
                try {
                    name = utils.InputBox("Input name of the new theme", "Create a new theme", this.themeData[themeId].name, true);
                    if (name) {
                        // check if name already exist
                        var ind = _.findIndex(this.themeData, { "name": name });
                        if (ind != -1) { utils.MessageBox("you entered a name that already exist", "Duplicate name", MB_OK | MB_ICONEXCLAMATION) }
                        else {
                            this.themeData[themeId].name = name;
                            this.save_status(themeFile, this.themeData)
                        }
                    }
                } catch (e) { return; }
                break;
            case idx <= 844 && idx >= 835: // delete
                var themeId = idx - 835;
                if (this.themeChoosen > -1) { var name = this.themeData[this.themeChoosen].name; }
                this.themeData.splice(themeId, 1);
                if (this.themeChoosen > -1) {
                    var ind = _.findIndex(this.themeData, { "name": name });
                    if (ind != -1) this.themeChoosen = ind; else this.themeChoosen = -1; //<-- the current one got deleted
                }
                this.save_status(themeFile, this.themeData)
                break;

            case idx == 1050: //auto collapse
                if (this.autocollapse == false) {
                    for (var i = 0; i < this.data.length; i++) {
                        if (this.data[i].foldState == '1' && this.data[i].lvl == '0') this.data[i].foldState = '0';
                    }
                }
                this.cleanup();
                selected.index = -1;
                this.offset = 0;
                this.themeChoosen = -1;
                window.Repaint();
                this.autocollapse = !this.autocollapse;
                window.SetProperty("PL.AUTOCOLLAPSE.BOOL", this.autocollapse);
                break;
            case idx == 1060:
                this.bgpic = !this.bgpic;
                window.SetProperty("PL.BACKGROUNDPIC.BOOL", this.bgpic);
                this.setBkgroundImg();
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1061:
                this.bgpic = false;
                this.colours_background = utils.ColourPicker(this.colours_background);
                window.SetProperty("PL.BACKGROUNDPIC.BOOL", this.bgpic);
                window.SetProperty("PL.BACKGROUND.COLOR", this.colours_background);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1062:
                this.bgpic = false;
                if (window.IsDefaultUI) this.colours_background = window.GetColourDUI(1);
                else this.colours_background = window.GetColourCUI(3);
                window.SetProperty("PL.BACKGROUNDPIC.BOOL", this.bgpic);
                window.SetProperty("PL.BACKGROUND.COLOR", this.colours_background);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1063:
                this.BGaspect_value = 2;
                window.SetProperty("PL.BACKGROUNDPIC.ASPECT", this.BGaspect_value);
                window.repaint();
                break;
            case idx == 1064:
                this.BGaspect_value = 3;
                window.SetProperty("PL.BACKGROUNDPIC.ASPECT", this.BGaspect_value);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1068:
                this.header == 0 ? this.header = 1 : this.header = 0;
                this.ylist = 0 + (TM * this.header);
                this.h = this.panel_h - (TM * this.header);
                this.rows = Math.floor((this.h - _scale(1)) / this.row_height);
                p_scrollbar.setSize(this.panel_w - cScrollBar.width, this.ylist, cScrollBar.width, this.h);
                p_scrollbar.setCursor(this.rows, this.items, this.offset);
                window.SetProperty("PL.HEADER.VISIBLE", this.header);
                this.themeChoosen = -1;
                window.repaint();
                break;

            case idx == 1070:
                this.but_color = utils.ColourPicker(this.but_color);
                window.SetProperty("PL.BUTTONS.COLOR", this.but_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1075:
                this.headerline_color = utils.ColourPicker(this.headerline_color);
                window.SetProperty("PL.HEADERLINE.COLOR", this.headerline_color);
                this.themeChoosen = -1;
                window.repaint();
                break;

            case idx == 1081:
                this.text_color = utils.ColourPicker(this.text_color);
                window.SetProperty("PL.TEXT.COLOR", this.text_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1082:
                this.folder_color = utils.ColourPicker(this.folder_color);
                window.SetProperty("PL.FOLDER.COLOR", this.folder_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1083:
                if (window.IsDefaultUI) this.text_color = window.GetColourDUI(0);
                else this.text_color = window.GetColourCUI(0);
                this.folder_color = this.text_color;
                window.SetProperty("PL.TEXT.COLOR", this.text_color);
                window.SetProperty("PL.FOLDER.COLOR", this.folder_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1084:
                this.folderIcon_color = utils.ColourPicker(this.folderIcon_color);
                window.SetProperty("PL.FOLDERICON.COLOR", this.folderIcon_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1085:
                this.folderIcon_color = this.text_color;
                window.SetProperty("PL.FOLDERICON.COLOR", this.folderIcon_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1086:
                this.foldertext_weight == 0 ? this.foldertext_weight = 1 : this.foldertext_weight = 0;
                window.SetProperty("PL.FOLDERTEXT.WEIGHT", this.foldertext_weight);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1150:
                this.thousandSeparator = Separator[0];
                window.SetProperty("PL.TEXT.000SEPARATOR", this.thousandSeparator);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1151:
                this.thousandSeparator = Separator[1];
                window.SetProperty("PL.TEXT.000SEPARATOR", this.thousandSeparator);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1152:
                this.thousandSeparator = Separator[2];
                window.SetProperty("PL.TEXT.000SEPARATOR", this.thousandSeparator);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1153:
                this.thousandSeparator = Separator[3];
                window.SetProperty("PL.TEXT.000SEPARATOR", this.thousandSeparator);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1160:
                this.folderIcon = 0;
                window.SetProperty("PL.FOLDER.ICON", 0);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1161:
                this.folderIcon = 1;
                window.SetProperty("PL.FOLDER.ICON", 1);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1165:
                this.scrollWidth = 0;
                cScrollBar.width = (this.scrollWidth * 10) + 10;
                window.SetProperty("PL.SCROLLBAR.WIDTH", 0);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1166:
                this.scrollWidth = 1;
                cScrollBar.width = (this.scrollWidth * 10) + 10;
                window.SetProperty("PL.SCROLLBAR.WIDTH", 1);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1167:
                this.scrollWidth = 2;
                cScrollBar.width = (this.scrollWidth * 10) + 10;
                window.SetProperty("PL.SCROLLBAR.WIDTH", 2);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1168:
                this.scrollWidth = 3;
                cScrollBar.width = (this.scrollWidth * 10) + 10;
                window.SetProperty("PL.SCROLLBAR.WIDTH", 3);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1268:
                this.scrollColor = utils.ColourPicker(this.scrollColor);
                window.SetProperty("PL.SCROLLBAR.COLOR", this.scrollColor);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1269: //default
                this.scrollColor = this.text_color;
                window.SetProperty("PL.SCROLLBAR.COLOR", this.scrollColor);
                this.themeChoosen = -1;
                this.size();
                window.repaint();
                break;
            case idx == 1170:
                this.displayStats = 0;
                window.SetProperty("PL.TEXT.STATSDISPLAY", 0);
                window.repaint();
                break;
            case idx == 1171:
                this.displayStats = 1;
                window.SetProperty("PL.TEXT.STATSDISPLAY", 1);
                window.repaint();
                break;
            case idx == 1172:
                this.displayStats = 2;
                window.SetProperty("PL.TEXT.STATSDISPLAY", 2);
                window.repaint();
                break;
            case idx == 1173:
                this.displayStats = 3;
                window.SetProperty("PL.TEXT.STATSDISPLAY", 3);
                window.repaint();
                break;
            case idx == 1177:
                this.mouseScrollSpeed_value = 1;
                window.SetProperty("PL.MOUSESCROLLSPEED.VALUE", 1);
                break;
            case idx == 1178:
                this.mouseScrollSpeed_value = 2;
                window.SetProperty("PL.MOUSESCROLLSPEED.VALUE", 2);
                break;
            case idx == 1179:
                this.mouseScrollSpeed_value = 3;
                window.SetProperty("PL.MOUSESCROLLSPEED.VALUE", 3);
                break;
            case idx == 1088:
                this.selection_color = utils.ColourPicker(this.selection_color);
                window.SetProperty("PL.SELECTION.COLOR", this.selection_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1089:
                this.selection_color = RGB(62, 87, 109);
                window.SetProperty("PL.SELECTION.COLOR", this.selection_color);
                this.themeChoosen = -1;
                window.repaint();
                break;
            case idx == 1091:
                this.openPLclick == 0 ? this.openPLclick = 1 : this.openPLclick = 0;
                window.SetProperty("PL.PLCLICK.BOOL", this.openPLclick);
                break;
            case idx == 1093:
                this.dblCkPlaySong == 0 ? this.dblCkPlaySong = 1 : this.dblCkPlaySong = 0;
                window.SetProperty("PL.PLDBLCLICK.PLAYSONG", this.dblCkPlaySong);
                break;
            case idx == 1095:
                this.delOption == 0 ? this.delOption = 1 : this.delOption = 0;
                window.SetProperty("PL.DELOPTION.BOOL", this.delOption);
                break;
            case idx == 1096:
                this.contextMoveUpDown == 0 ? this.contextMoveUpDown = 1 : this.contextMoveUpDown = 0;
                window.SetProperty("PL.CONTEXTMOVEUPDOWN.BOOL", this.contextMoveUpDown);
                break;
            case idx == 1197:
                this.lockStatus == 0 ? this.lockStatus = 1 : this.lockStatus = 0;
                window.SetProperty("PL.LOCK.STATUS", this.lockStatus);
                window.repaint();
                break;
            case idx == 1198:
                this.nodeIndent == 0 ? this.nodeIndent = 18 : this.nodeIndent = 0;
                window.SetProperty("PL.NODEINDENT.VALUE", this.nodeIndent);
                window.repaint();
                break;
            case idx == 1098:
                this.activeSongOption = 0;
                window.SetProperty("PL.ACTIVESONG.BOOL", this.activeSongOption);
                this.activeSong_color = utils.ColourPicker(this.activeSong_color);
                window.SetProperty("PL.ACTIVESONG.COLOR", this.activeSong_color);
                this.off = 5;
                window.repaint();
                break;
            case idx == 1099:
                this.activeSongOption == 0 ? (this.activeSongOption = 1, this.off = 35) : (this.activeSongOption = 0, this.off = 5);
                window.SetProperty("PL.ACTIVESONG.BOOL", this.activeSongOption);
                window.repaint();
                break;
            case idx == 1100:
                var content = utils.ReadUTF8(statusFile);
                utils.WriteTextFile(archiveFile, content);
                archiveFileStatus = true;
                break;
            case idx == 1101:
                if (utils.MessageBox("Are you sure you want to overwrite the config file ? there is no going back", "Restore config file", MB_YESNO | MB_ICONQUESTION) == IDYES) {
                    var content = utils.ReadUTF8(archiveFile);
                    utils.WriteTextFile(statusFile, content);
                    this.update();
                }
                break;
            case idx == 1190:
                showHelp();
                break;
            case idx == 1191:
                utils.Run('https://hydrogenaud.io/index.php/topic,123820.0.html');
                break;
            case idx == 2000:
                window.ShowConfigure();
                break;
            case idx == 1200: //move up
                this.moveUD('up');
                break;
            case idx == 1250: //move down
                this.moveUD('down');
                if (selected.index - this.offset == this.rows) this.offset++;
                break;
            case idx == 1300:
                plman.ShowAutoPlaylistUI(plId);
                break;
            case idx == 1400: // rename a playlist
                this.rename();
                break;
                break;
            case idx == 1450: //sort asc
                this.data = sortArray(this.data, filt, 1);
                this.cleanup();
                window.Repaint();
                break;
            case idx == 1460: //sort desc
                this.data = sortArray(this.data, filt, 0);
                this.cleanup();
                window.Repaint();
                break;
            case idx == 1500: //create a folder
                try {
                    name = utils.InputBox("Input name of the new folder", "Create Folder", "New folder");
                } catch (e) { return; }
                if (name) {
                    if (_.findIndex(this.data, { name: name }) == -1) {
                        var ind = _.findIndex(this.data, { id: this.display[selected.index].id });
                        this.data.splice(ind, 0, {
                            "position": selected.index,
                            "name": name,
                            "value": '0',
                            "pl": '0',
                            "lvl": Number(this.display[selected.index].lvl),
                            "fold": this.display[selected.index].fold,
                            "foldState": '0',
                            id: ++this.foldCount,
                        });

                        this.cleanup();
                        this.wheel(0);
                        window.Repaint();
                    }
                    else
                        utils.MessageBox("You can't create a folder which name : " + name + " already exists", "Warning", MB_OK);
                }
                break;
            case idx == 1600: //create autoplaylist
                try {
                    name = utils.InputBox("Input name of the new Autoplaylist", "Create AutoPlaylist");
                } catch (e) { return; }
                if (name) {
                    var newind = plman.CreateAutoPlaylist(plman.PlaylistCount, name, "enter your query here");
                    plman.ActivePlaylist = newind;
                    plman.ShowAutoPlaylistUI(newind);
                }
                break;
            case idx == 1630: // create playlist
                try {
                    name = utils.InputBox("Input name of the new playlist", "Create Playlist");
                } catch (e) { return; }
                if (name) {
                    var newind = plman.CreatePlaylist(plman.PlaylistCount, name);
                    plman.ActivePlaylist = newind;
                }
                break;

            case idx == 1660: // convert into a regular playlist
                var newind = plman.DuplicatePlaylist(plId, this.display[selected.index].name);
                plman.RemovePlaylist(plId);
                this.data[_.findIndex(this.data, { id: this.display[selected.index].id })].id = plman.GetGUID(newind);
                plman.ActivePlaylist = newind;
                break;
            case idx == 1700: // delete PL or folder
                this.delete();
                /* this.countFold();
                this.cleanup();
                this.wheel(0);
                window.Repaint(); */
                break;
            case idx > 1700 && idx < 1791:
                plman.RecyclerRestore(idx - 1701);
                break;
            case idx == 1791: //purge Recycler
                var arr = [];
                var count = plman.RecyclerCount;
                for (var i = 0; i < count; i++) {
                    arr.push(i);
                }
                plman.RecyclerPurge(arr);
                break;
            case idx == 1795: // Edit lock 
                plman.ShowPlaylistLockUI(plId);
                break;
            case idx == 1796: // Remove lock 
                plman.RemovePlaylistLock(plId);
                break;
            case idx == 1800: // Unfolderize playlist
                this.display[selected.index].lvl = '0';
                this.display[selected.index].fold = '';
                this.countFold();
                this.cleanup();
                this.wheel(0);
                window.Repaint();
                break;
            case idx >= 2000 && idx <= 2000 + this.data.length:
                var ind = _.findIndex(this.data, { id: this.display[selected.index].id });
                this.data[ind].lvl = Number(this.data[idx - 2000].lvl) + 1;  // increment the level from the folder
                this.data[ind].fold = this.data[idx - 2000].name;
                selected.index = -1;
                this.countFold();
                this.cleanup();
                this.wheel(0);
                window.Repaint();
                break;
            case idx >= 10000:
                this._context.ExecuteByID(idx - 10000);
                break;
        }
        _dispose(this._context, this._items, this.l1, this.l10, this.l11, this.l13, this.l3, this.l7, this.menuAppearance, this.menuColors, this.l14);
        _dispose(this.menuContextSettings, this.menuCreate, this.menuFolders, this.menuHelp, this.menuIcons, this.menuKeyboard, this.menuMouse);
        _dispose(this.themeMgt, this.l15, this.l16, this.l17, this.l18, this.opacitybkMenu, this.menuMouseScrolling, this.menuMove, this.menuRestore, this.menuSettings, this.menuSort, this.menuText, this.menuTextColors, this.s, this.ScrollMenu);
    }

    this.key_up = function (k) {
        switch (k) {
            case VK_CONTROL:
                this.ctrl = false;
                break;
        }
    }

    this.key_down = function (k) {
        if (this.inputboxID == 1) {
            if (k == VK_SHIFT) {
                this.inputboxID = -1; window.repaintRect(0, 0, this.panel_w, 30);
            }
            this.inputbox.on_key_down(k);
        }
        else {
            switch (k) {
                case VK_HOME:
                    selected.index = 0;
                    this.setSel(selected.index);
                    this.offset = 0;
                    p_scrollbar.setCursor(this.rows, this.items, this.offset);
                    window.Repaint();
                    break;
                case VK_END:
                    selected.index = this.items - 1;
                    this.setSel(selected.index);
                    this.offset = this.items - this.rows;
                    p_scrollbar.setCursor(this.rows, this.items, this.offset);
                    window.Repaint();
                    break;
                case VK_UP:
                    if (selected.index !== -1 && selected.index !== 0) {
                        selected.index--;
                        this.setSel(selected.index);
                        if (selected.index - this.offset == -1) this.offset--;
                        p_scrollbar.setCursor(this.rows, this.items, this.offset);
                        window.Repaint();
                    }
                    break;
                case VK_DOWN:
                    if (selected.index !== -1 && selected.index !== this.items - 1) {
                        selected.index++;
                        this.setSel(selected.index);
                        if (selected.index - this.offset == this.rows) this.offset++;
                        p_scrollbar.setCursor(this.rows, this.items, this.offset);
                        window.Repaint();
                    }
                    break;
                case VK_PRIOR:
                    if (selected.index + 2 >= this.rows) {
                        selected.index = selected.index - this.rows - 2;
                        this.setSel(selected.index);
                        if (selected.index < this.rows - 2) {
                            this.offset = 0;
                        } else {
                            this.offset = selected.index;
                        }
                    } else {
                        selected.index = 0;
                        this.setSel(selected.index);
                        this.offset = 0;
                    }
                    window.Repaint();
                    p_scrollbar.setCursor(this.rows, this.items, this.offset);
                    break;
                case VK_NEXT:
                    if (selected.index <= this.items - this.rows - 3) {
                        if (selected.index == 0) {
                            selected.index = selected.index + this.rows + 2;
                        } else {
                            selected.index = selected.index + this.rows - 1;
                        }
                        this.setSel(selected.index);
                        if (this.data.length - this.rows - 3 <= selected.index) {
                            this.offset = this.items - this.rows;
                        } else {
                            this.offset = selected.index;
                        }
                    } else {
                        selected.index = this.items - 1;
                        this.setSel(selected.index);
                        this.offset = this.items - this.rows;
                    }
                    p_scrollbar.setCursor(this.rows, this.items, this.offset);
                    window.Repaint();
                    break;
                case VK_LEFT:
                    if ((selected.pl == 0) && (this.display[selected.index].foldState == 1)) {
                        this.display[selected.index].foldState = 0;
                    } else if (this.display[selected.index].lvl > 0 && selected.pl == 1) {
                        while (selected.index > 0) {
                            if (this.display[selected.index].pl == 0) {
                                this.setSel(selected.index);
                                if (selected.index - this.offset <= 0) {
                                    this.offset = selected.index;
                                }
                                break;
                            } else {
                                selected.index--;
                            }
                        }
                    }
                    this.cleanup();
                    p_scrollbar.setCursor(this.rows, this.items, this.offset);
                    window.Repaint();
                    break;
                case VK_RIGHT:
                    if ((selected.pl == 0) && (this.display[selected.index].foldState == 0)) {
                        this.display[selected.index].foldState = 1;
                        this.cleanup();
                        p_scrollbar.setCursor(this.rows, this.items, this.offset);
                        window.Repaint();
                    }
                    break;
                case VK_DELETE:
                    if (this.delOption)
                        this.delete();
                    else console.log("Playlist Organizer: <Delete> key is disabled");
                    break;
                case VK_SUBTRACT:
                    this.moveUD('up');
                    break;
                case VK_ADD:
                    this.moveUD('down');
                    break;
                case VK_RETURN:
                    if (selected.pl != 0) {
                        plman.ActivePlaylist = plman.FindPlaylist(this.display[selected.index].name);
                    }
                    window.Repaint();
                    break;
                case VK_F2:
                    this.rename();
                    break;
                case VK_CONTROL:
                    this.ctrl = true;
                    break;
                case VK_SHIFT:
                    this.searchbox();
                    break;
                default:
                    return false;
            }
        }
    }

    this.moveUD = function (direction) {
        if (selected.index !== -1) {
            var from = _.findIndex(this.data, { id: this.display[selected.index].id });
            direction == 'up' ? to = from - 1 : to = from + 1;
            var id = this.data.move(from, to);
            this.cleanup();
            this.setSel(_.findIndex(this.display, { id: id }));
            if (selected.index - this.offset == -1) this.offset--; else if (selected.index - this.offset == this.rows) this.offset++;
            p_scrollbar.setCursor(this.rows, this.items, this.offset);
            window.Repaint();
        }
    }

    this.rename = function () {
        try {
            var tooBrenamed = this.display[selected.index].pl == 1 ? "playlist" : "folder";
            value = utils.InputBox("Give a new name to this " + tooBrenamed, "Rename " + tooBrenamed, this.display[selected.index].name, true);
            switch (this.display[selected.index].pl) {
                case "0":  //folder
                    if (_.findIndex(this.data, { name: value }) == -1) {
                        var ind = _.findIndex(this.data, { id: this.display[selected.index].id });
                        for (var i = 0; i < this.data.length; i++) {
                            if (this.data[i].fold == this.data[ind].name) this.data[i].fold = value;
                        }
                        this.data[ind].name = value;
                    }
                    else
                        utils.MessageBox("You can't rename a folder which name : " + value + " already exists", "Warning", MB_OK);
                    break;
                case "1": //playlist
                    plman.RenamePlaylist(plId, value);
                    break;
            }
            this.cleanup();
            window.Repaint();
        } catch (e) { return; }
    }

    this.delete = function () {
        if (selected.index !== -1) {
            if (selected.pl == 1) { plman.RemovePlaylist(plman.FindByGUID(this.display[selected.index].id)); }
            else { // delete folder
                for (var i = 0; i < this.data.length; i++) { //content of folder
                    if (this.data[i].fold == this.display[selected.index].name) {
                        if (this.data[i].pl == 1) {
                            this.data[i].fold = this.display[selected.index].fold;
                            this.data[i].lvl = Math.max(Number(this.data[i].lvl) - 1, 0);
                            // playlist contained in the deleted folder falls into the mother folder
                        }
                        else { //folder
                            for (var j = 0; j < this.data.length; j++) {
                                if (this.data[j].fold == this.data[i].name) {
                                    this.data[j].lvl = Math.max(Number(this.data[j].lvl) - 1, 0); // each pl within that subfolder sees its lvl decrease by 1
                                }
                            }
                            this.data[i].fold = this.display[selected.index].name;
                            this.data[i].lvl = Math.max(Number(this.data[i].lvl) - 1, 0);
 
                        }
                    }
                }
            }
            var index = _.findIndex(this.data, { id: this.display[selected.index].id });
            this.data.splice(index, 1); //delete
            this.countFold();
            this.cleanup();
            this.setSel(Math.max(0, Math.min(this.items - 1, selected.index--)));
            this.wheel(0);
            window.Repaint();
        }
    }
 
    this.setBkgroundImg = function () {
        if (g_wallpaperImg) {
            g_wallpaperImg.Dispose();
            g_wallpaperImg = null;
        }
        if (this.bgpic && fb.IsPlaying) {
            var metadb = fb.GetNowPlaying();
            if (metadb) var tmp = metadb.GetAlbumArt();
            if (tmp) g_wallpaperImg = metadb.GetAlbumArt();
        }
    }
 
    this.countFold = function () {
        for (var i = 0; i < this.data.length; i++) {
            if (this.data[i].pl == '0') { // folder
                var tot = 0;
                for (var j = 0; j < this.data.length; j++) {
                    if (this.data[j].fold == this.data[i].name)
                        tot = tot + Number(this.data[j].value);
                    this.data[i].value = tot;
                }
            }
        }
    }
  
    this.save_status = function (file, data) { // Save latest to file
        _save(file, JSON.stringify(data));
    }
 
    this.getFileData = function () { //get file archived status
        var text = utils.ReadUTF8(statusFile);
        dataFile = [];
        try {
            dataFile = JSON.parse(text);
        }
        catch (e) {
            var arr = text.split(/\r?\n/)
            for (var i = 1; i < arr.length; i++) {
                var fields = arr[i].split(';');
                dataFile.push({
                    "position": fields[0],
                    "name": fields[1],
                    "value": fields[2],
                    "pl": fields[3],
                    "lvl": fields[4],
                    "fold": fields[5],
                    "foldState": fields[6],
                });
            }
        }
        this.BuildData(dataFile);
    }
    this.BuildData = function (dataFile) { // merge file situation to current playlist array (this.data)
        var temparr = [];
        // get positions & lvls
        for (var i = 0; i < this.data.length; i++) {
            var index = _.findIndex(dataFile, { name: this.data[i].name })
            if (index != -1) {
                this.data[i].position = dataFile[index].position;
                this.data[i].pl = dataFile[index].pl;
                this.data[i].lvl = dataFile[index].lvl;
                this.data[i].fold = dataFile[index].fold;
                this.data[i].foldState = dataFile[index].foldState;
            }
            else {
                temparr.push(i);
            }
        }
        // integrate new playlist (not created through this this.panel with default values
        if (temparr.length != 0) {
            for (var i = 0; i < temparr.length; i++) {
                this.data[temparr[i]].position = this.data.length - temparr.length + i;
                this.data[temparr[i]].pl = '1';
                this.data[temparr[i]].lvl = '0';
            }
        }
        // folders to integrate
        var dataFileFolder = dataFile.filter(function (artr) {
            return artr.pl == '0';
        });
        if (dataFileFolder.length) {
            for (var i = 0; i < dataFileFolder.length; i++) {
                dataFileFolder[i].id = ++this.foldCount;
                this.data.push(dataFileFolder[i]);
            }
        }
        this.data.sort(dynamicSort("position")); // ne trie pas par chiffre mais par texte a comparer   l'autre plus bas (je crois)
    }
 
    this.getData = function () {    // get current playlists
        var data = [];
        for (var i = 0; i < plman.PlaylistCount; i++) {
            var name = plman.GetPlaylistName(i);
            data.push({
                name: name,
                value: plman.GetPlaylistItemCount(i),
                position: '0',
                pl: '0',
                lvl: '0',
                fold: "",
                foldState: '',
                size: plman.GetPlaylistItems(i).CalcTotalSize(),
                id: plman.GetGUID(i),
            });
        }
        return data;
    }
    this.getThemeData = function () {
        var data = [];
        if (themeFileStatus) {
            var text = utils.ReadUTF8(themeFile);
            try {
                data = JSON.parse(text);
            }
            catch (e) {
            }
        }
        return data;
    }

    this.pushTheme = function (name) {
        this.themeData.push({
            name: name,
            this_autocollapse: this.autocollapse,
            this_bgpic: this.bgpic,
            this_but_color: this.but_color,
            this_colours_background: this.colours_background,
            this_colours_highlight: this.colours_highlight,
            this_folder_color: this.folder_color,
            this_fontSize_value: this.fontSize_value,
            this_selection_color: this.selection_color,
            this_text_color: this.text_color,
            this_activeSongOption: this.activeSongOption,
            this_activeSong_color: this.activeSong_color,
            this_folderIcon_color: this.folderIcon_color,
            this_foldertext_weight: this.foldertext_weight,
            this_headerline_color: this.headerline_color,
            this_thousandSeparator: this.thousandSeparator,
            this_folderIcon: this.folderIcon,
            this_displayStats: this.displayStats,
            this_header: this.header,
            this_scrollWidth: this.scrollWidth,
            this_scrollColor: this.scrollColor,
            this_opacity_perc_value: this.opacity_perc_value,
            this_BGaspect_value: this.BGaspect_value,
            this_nodeIndent: this.nodeIndent,
        });
    }
    this.restoreTheme = function () {
        this.autocollapse = this.themeData[this.themeChoosen].this_autocollapse;
        this.bgpic = this.themeData[this.themeChoosen].this_bgpic;
        this.but_color = this.themeData[this.themeChoosen].this_but_color;
        this.colours_background = this.themeData[this.themeChoosen].this_colours_background;
        this.colours_highlight = this.themeData[this.themeChoosen].this_colours_highlight;
        this.folder_color = this.themeData[this.themeChoosen].this_folder_color;
        this.fontSize_value = this.themeData[this.themeChoosen].this_fontSize_value;
        this.selection_color = this.themeData[this.themeChoosen].this_selection_color;
        this.text_color = this.themeData[this.themeChoosen].this_text_color;
        this.activeSongOption = this.themeData[this.themeChoosen].this_activeSongOption;
        this.activeSongOption == 1 ? this.off = 35 : this.off = 5;
//        this.activeSongOption == 0 ? (this.activeSongOption = 1, this.off = 35) : (this.activeSongOption = 0, this.off = 5);
        this.activeSong_color = this.themeData[this.themeChoosen].this_activeSong_color;
        this.folderIcon_color = this.themeData[this.themeChoosen].this_folderIcon_color;
        this.foldertext_weight = this.themeData[this.themeChoosen].this_foldertext_weight;
        this.headerline_color = this.themeData[this.themeChoosen].this_headerline_color;
        this.thousandSeparator = this.themeData[this.themeChoosen].this_thousandSeparator;
        this.folderIcon = this.themeData[this.themeChoosen].this_folderIcon;
        this.displayStats = this.themeData[this.themeChoosen].this_displayStats;
        this.header = this.themeData[this.themeChoosen].this_header;
        this.scrollWidth = this.themeData[this.themeChoosen].this_scrollWidth;
        this.scrollColor = this.themeData[this.themeChoosen].this_scrollColor;
        this.opacity_perc_value = this.themeData[this.themeChoosen].this_opacity_perc_value;
        this.BGaspect_value = this.themeData[this.themeChoosen].this_BGaspect_value;
        this.nodeIndent = this.themeData[this.themeChoosen].this_nodeIndent;
        
        // store value in properties
        window.SetProperty("PL.AUTOCOLLAPSE.BOOL", this.autocollapse);
        window.SetProperty("PL.BACKGROUNDPIC.BOOL", this.bgpic);
        window.SetProperty("PL.BUTTONS.COLOR", this.but_color);
        window.SetProperty("PL.BACKGROUND.COLOR", this.colours_background);
        window.SetProperty("PL.HIGHLIGHT.COLOR", this.colours_highlight);
        window.SetProperty("PL.FOLDER.COLOR", this.folder_color);
        window.SetProperty("PL.FONTSIZE.VALUE", this.fontSize_value);
        window.SetProperty("PL.SELECTION.COLOR", this.selection_color);
        window.SetProperty("PL.TEXT.COLOR", this.text_color);
        window.SetProperty("PL.ACTIVESONG.BOOL", this.activeSongOption);
        window.SetProperty("PL.ACTIVESONG.COLOR", this.activeSong_color);
        window.SetProperty("PL.FOLDERICON.COLOR", this.folderIcon_color);
        window.SetProperty("PL.FOLDERTEXT.WEIGHT", this.foldertext_weight);
        window.SetProperty("PL.HEADERLINE.COLOR", this.headerline_color);
        window.SetProperty("PL.TEXT.000SEPARATOR", this.thousandSeparator);
        window.SetProperty("PL.FOLDER.ICON", this.folderIcon);
        window.SetProperty("PL.TEXT.STATSDISPLAY", this.displayStats);
        window.SetProperty("PL.HEADER.VISIBLE", this.header);
        window.SetProperty("PL.SCROLLBAR.WIDTH", this.scrollWidth);
        window.SetProperty("PL.SCROLLBAR.COLOR", this.scrollColor);
        window.SetProperty("PL.BACKGROUNDPIC.OPACITY", this.opacity_perc_value);
        window.SetProperty("PL.BACKGROUNDPIC.ASPECT", this.BGaspect_value);
        window.SetProperty("PL.NODEINDENT.VALUE", this.nodeIndent);
    }
    this.getStoredValues = function () {
        this.autocollapse = window.GetProperty("PL.AUTOCOLLAPSE.BOOL", false);
        this.bgpic = window.GetProperty("PL.BACKGROUNDPIC.BOOL", 1);
        this.but_color = window.GetProperty("PL.BUTTONS.COLOR", RGB(255, 255, 0));
        this.colours_background = window.GetProperty("PL.BACKGROUND.COLOR", this.colours_background);
        this.colours_highlight = window.GetProperty("PL.HIGHLIGHT.COLOR", this.text_color);
        this.folder_color = window.GetProperty("PL.FOLDER.COLOR", this.text_color);
        this.fontSize_value = window.GetProperty("PL.FONTSIZE.VALUE", 12);
        this.selection_color = window.GetProperty("PL.SELECTION.COLOR", RGB(62, 87, 109));
        this.text_color = window.GetProperty("PL.TEXT.COLOR", this.text_color);
        window.SetTooltipFont('Segoe UI', _scale(this.fontSize_value));
        this.openPLclick = window.GetProperty("PL.PLCLICK.BOOL", 0);
        this.delOption = window.GetProperty("PL.DELOPTION.BOOL", 1);
        this.contextMoveUpDown = window.GetProperty("PL.CONTEXTMOVEUPDOWN.BOOL", 1);
        this.activeSongOption = window.GetProperty("PL.ACTIVESONG.BOOL", 1);
        if (this.activeSongOption == 0) this.off = 5; else this.off = 35;
        this.activeSong_color = window.GetProperty("PL.ACTIVESONG.COLOR", this.text_color);
        this.folderIcon_color = window.GetProperty("PL.FOLDERICON.COLOR", this.text_color);
        this.foldertext_weight = window.GetProperty("PL.FOLDERTEXT.WEIGHT", 1);
        this.headerline_color = window.GetProperty("PL.HEADERLINE.COLOR", RGB(255, 0, 0));
        this.thousandSeparator = window.GetProperty("PL.TEXT.000SEPARATOR", 1);
        this.folderIcon = window.GetProperty("PL.FOLDER.ICON", 0);
        this.displayStats = window.GetProperty("PL.TEXT.STATSDISPLAY", 0);
        this.header = window.GetProperty("PL.HEADER.VISIBLE", 1);
        this.ylist = 0 + (TM * this.header);
        this.dblCkPlaySong = window.GetProperty("PL.PLDBLCLICK.PLAYSONG", 0);
        this.lockStatus = window.GetProperty("PL.LOCK.STATUS", 1);
        this.mouseScrollSpeed_value = window.GetProperty("PL.MOUSESCROLLSPEED.VALUE", 3);
        this.nodeIndent = window.GetProperty("PL.NODEINDENT.VALUE", 0);
        this.BGaspect_value = window.GetProperty("PL.BACKGROUNDPIC.ASPECT", 2);
        this.scrollWidth = window.GetProperty("PL.SCROLLBAR.WIDTH", 1);
        cScrollBar.width = (this.scrollWidth * 10) + 10;
        this.scrollColor = window.GetProperty("PL.SCROLLBAR.COLOR", this.text_color);
        this.opacity_perc_value = window.GetProperty("PL.BACKGROUNDPIC.OPACITY", 10);
        this.themeChoosen = window.GetProperty("PL.THEME.NUMBER", -1);
    }

    this.font_changed = function () {
        this.fonts.pl = JSON.parse(window.IsDefaultUI ? window.GetFontDUI(3) : window.GetFontCUI(0)).Name;
        this.fonts.folder = JSON.parse(window.IsDefaultUI ? window.GetFontDUI(2) : window.GetFontCUI(1)).Name;
        this.fonts_playlist = JSON.stringify({ Name: this.fonts.pl, Size: _scale(this.fontSize_value) });
        this.fonts_folder = JSON.stringify({ Name: this.fonts.folder, Size: _scale(this.fontSize_value) });
        this.fonts_folder_bold = JSON.stringify({ Name: this.fonts.folder, Weight: DWRITE_FONT_WEIGHT_BOLD, Size: _scale(this.fontSize_value) });
        this.fonts.awesome = JSON.stringify({ Name: 'FontAwesome', Weight: DWRITE_FONT_WEIGHT_BOLD, Size: _scale(this.fontSize_value) });
        this.fonts.awesome12 = JSON.stringify({ Name: 'FontAwesome', Weight: DWRITE_FONT_WEIGHT_BOLD, Size: 12 });
        this.row_height = _scale(this.fontSize_value + 4);
    }
 
    this.colours_def = function () {
        if (window.IsDefaultUI) {
            this.colours_background = window.GetColourDUI(1);
            this.text_color = window.GetColourDUI(0);
            this.colours_highlight = window.GetColourDUI(2);
        } else {
            this.colours_background = window.GetColourCUI(3);
            this.text_color = window.GetColourCUI(0);
            this.colours_highlight = blendColours(this.colours_text, this.colours_background, 0.4);
        }
    }
 
    this.update = function () {
        this.colours_def();
        this.getStoredValues();
        this.font_changed();
        this.dragDrop = false;
        this.btnDown = false;
        this.data = this.getData();
        if (this.old_offset != 0) this.offset = this.old_offset; else this.offset = 0;
        this.index = 0;
        this.foldCount = 0;
        this.truncedId = [];
        this.getFileData();
        if (this.bgpic) this.setBkgroundImg();
        this.countFold();
        this.cleanup();
        this.themeData = this.getThemeData();
        p_scrollbar = new PlaylistScrollBar();
        window.Repaint();
    }

   this.cleanup = function () {
       this.display = [];
       var ind = 0;
       this.recurs("", ind);
       // stamp a far away position for pl which are not visible (not in display)
       temp = Object.create(null);
       this.display.forEach(function (a) {
           temp[a.id] = true;
       });
       this.data2 = this.data.filter(function (a) {
           return !temp[a.id];
       });
       for (var i = 0; i < this.data2.length; i++) {
           this.data2[i].position = (Number(this.data2[i].lvl) * 1000) + i;
       }
       /////////////////////////////////////////////////////
       this.data.sort(dynamicSort("position"));
       this.items = this.display.length;
       this.save_status(statusFile, this.data);
    }

    this.recurs = function (name, ind) {
        
        for (var i = 0; i < this.data.length; i++) {
            if (this.data[i].pl == '0' && this.data[i].foldState == '1' && this.data[i].fold == name) //folder and open then go one level below
            {
                ind++;
                this.data[i].position = (Number(this.data[i].lvl) * 100) + ind;
                this.display.push(this.data[i]);
                this.recurs(this.data[i].name, ind);
            }
            else {
                if (this.data[i].fold == name) {
                    ind++;
                    this.data[i].position = (Number(this.data[i].lvl) * 100) + ind;
                    this.display.push(this.data[i]);
                }
            }
        }
    } 
    this.calc_text_width = function (text) {
        return utils.CalcTextWidth(text, this.fonts.name, _scale(this.fontSize_value));
    }
    this.reset = function () {
        this.old_offset = this.offset; // to keep offset position when updating when focus change
        this.items = 0;
        this.data = [];
    }
    this.searchChars = function (txt) {
        if (txt.length > 2) {
            var id = "";
            for (var i = 0; i < this.display.length; i++) {
                if (this.display[i].name.toLowerCase().indexOf(txt.toLowerCase()) !== -1) {
                    //  if (this.display[i].name.toLowerCase().substring(0, txt.length) == txt.toLowerCase()) { // search start of string
                    id = this.display[i].id;
                    break;
                }
            }
            if (id) {
                var index = _.findIndex(this.display, { id: id });
                this.setSel(index);
                if (this.display[index].pl == 1)
                    plman.ActivePlaylist = plman.FindByGUID(this.display[index].id);
                if (index + 1 - this.rows != 0) {
                    if (index + 1 - this.offset >= this.rows) this.offset = this.offset + (index + 1 - this.rows);
                    else if (index - this.offset <= 0) this.offset = 0;
                }
                this.inputbox.bordercolor = RGB(0, 102, 0);
            }
            else {
                this.inputbox.bordercolor = RGB(255, 0, 0);
            }
        }
        else this.inputbox.bordercolor = RGB(255, 0, 0);
        window.repaint();
 
    }
 
    this.searchbox = function () {
        this.inputbox = new oInputbox(100, 30, "", "", this.text_color, this.colours_background, RGB(255, 0, 0), this.colours_background, "");
        this.inputbox.setSize(100, 30, g_fsize);
        this.inputboxID = 1;
        this.inputbox.on_focus(true);
        this.inputbox.edit = true;
        this.inputbox.Cpos = this.inputbox.text.length;
        this.inputbox.anchor = this.inputbox.Cpos;
        this.inputbox.SelBegin = this.inputbox.Cpos;
        this.inputbox.SelEnd = this.inputbox.Cpos;
        if (!cInputbox.timer_cursor) {
            this.inputbox.resetCursorTimer();
        }
        this.inputbox.dblclk = true;
        this.inputbox.SelBegin = 0;
        this.inputbox.SelEnd = this.inputbox.text.length;
        this.inputbox.text_selected = this.inputbox.text;
        this.inputbox.select = true;
 
        window.repaint();
    }
  /*  this.save_status2 = function (file) { // Helpfull to debug stuff
        strContents = "FORMAT : position;name;#files in PL (-1 if folder);playlist (yes = 1);lvl;folder name (if any) belonged to;folder status (1 = open)" + "\n";
        for (var i = 0; i < this.data.length; i++) {
            strContents = strContents + this.data[i].position + ";" + this.data[i].name + ";" + this.data[i].value + ";" + this.data[i].pl + ";" + this.data[i].lvl + ";" + this.data[i].fold + ";" + this.data[i].foldState + "\n";
        }
        _save(file, strContents);
    }
    this.save_status3 = function (file) { // Helpfull to debug stuff
        strContents = "FORMAT : position;name;#files in PL (-1 if folder);playlist (yes = 1);lvl;folder name (if any) belonged to;folder status (1 = open)" + "\n";
        for (var i = 0; i < this.display.length; i++) {
            strContents = strContents + this.display[i].position + ";" + this.display[i].name + ";" + this.display[i].value + ";" + this.display[i].pl + ";" + this.display[i].lvl + ";" + this.display[i].fold + ";" + this.display[i].foldState + "\n";
        }
        _save(file, strContents);
    }*/
    function showHelp() {
        var str =
            "NAME\n" +
            "   Playlist Organizer (for Jscript Panel)\n\n" +
 
            "DESCRIPTION\n" +
            "   A tree view playlist manager inspiried by the original foo_plorg.\n\n" +
 
            "FEATURES\n" +
            "   Playlist Organization\n" +
            "       - Auto-collapse folders to simplify your playlist view\n" +
            "       - Drag-and-drop folders and playlists to reorganize\n" +
            "       - Drag-and-drop items from other panels into playlists\n" +
            "       - Drag-and-drop items from other panels into an empty space to create a playlist\n" +
            "       - Sort nodes from the context menu\n" +
            "\n" +
            "   Playlist Management\n" +
            "       - Create/edit/rename/delete/restore folders, playlists, autoplaylists\n" +
            "       - Display and modify playlist lock attributes\n" +
            "       - Extensive right-click context menu options\n" +
            "\n" +
            "   Interface & Customization\n" +
            "       - Display various playlist statistics\n" +
            "       - Customize interface colors, background, icons, etc.\n" +
            "       - Optional keyboard shortcuts for navigation and playlist management\n" +
            "\n" +
            "   Theme management\n" +
            "       - Create up to 10 themes from the current configuration (name have to be unique)\n" +
            "       - Choose a theme amongst a list and change the current configuration\n" +
            "       - Update a theme with the current configuration\n" +
            "       - Rename a theme (cannot duplicate name)\n" +
            "       - Delete a theme\n" +
            "\n" +
            "   Backup & Restore Folder Structure\n" +
            "       - Backup/restore option to safeguard the playlist node structure\n" +
            "\n" +
            "INTERFACE\n" +
            "   Navigation\n" +
            "       - Activate playlists:\n" +
            "           - Single or double-click (depending on your settings)\n" +
            "           - Enter key\n" +
            "\n" +
            "       - Open or close a folder:\n" +
            "           - Double-click a folder item\n" +
            "           - Single-click the folder icon\n" +
            "           - Left and right cursor keys\n" +
            "\n" +
            "       - Scrolling:\n" +
            "           - Mouse wheel\n" +
            "           - Up/down cursor keys\n" +
            "           - Page up/down keys\n" +
            "           - End/begin keys\n" +
            "           - Middle button click" +
            "\n" +
            "   Context Menu\n" +
            "       Right-click context menu items accessible anywhere.\n" +
            "\n" +
            "       - Move up\n" +
            "           Move playlist item up\n" +
            "\n" +
            "       - Move down\n" +
            "           Move playlist item down\n" +
            "\n" +
            "       - Create\n" +
            "           Create folder, autoplaylist, or standard playlist\n" +
            "\n" +
            "       - Move to\n" +
            "           Relocate playlists into a different folder destination\n" +
            "\n" +
            "       - Rename\n" +
            "           Rename a folder or playlist item\n" +
            "\n" +
            "       - Sort folder\n" +
            "           Sorts the items of a given folder\n" +
            "\n" +
            "       - Delete\n" +
            "           Delete a folder or playlist\n" +
            "\n" +
            "       - Content\n" +
            "           foobar2000's standard context menu based on selected playlist\n" +
            "\n" +
            "       - Restore\n" +
            "           Choose previously deleted playlist to restore\n" +
            "           Remembers a maximum of 90 playlists\n" +
            "           Option to purge all deleted playlists from history\n" +
            "\n" +
            "       - Settings\n" +
            "           Change behavioral and UI options, backup, etc.\n" +
            "\n" +
            "LIMITATIONS\n" +
            "   - Folder names must be unique.\n" +
            "   - Multiple selection of playlist items unavailable.\n" +
            "\n" +
            "SEE ALSO\n" +
            "   https://hydrogenaud.io/index.php/topic,123820.0.html\n" +
            "\n" +
            "AUTHOR\n" +
            "   Seb (etip). Inspiration and abstracts from marc2003, great help from metal_termite.\n"
            ;
        utils.ShowPopupMessage(str, "Playlist Organizer Help");
    }
 
 
    this.y = 0; // top of the panel
    //  top of the list after the header
    this.layerUp = _scale(2);
    this.index = 0;
    this.offset = 0;
    this.old_offset = 0; // to recall position when playlist has changed and need to recalculate (to avoid the list systematically going on the top)
    this.items = 0;
    this.ctrl = false;
    this.fonts_sizes = [8, 9, 10, 12, 14, 16, 20];
    this.opacity_perc = [10, 20, 30, 40, 50, 60, 70, 80];
    this.off = 35;
    this.fonts = {};
    this.list_objects = [];
    this.text_objects = [];
    this.list_objects.push(this);
}
 
function on_char(code) {
    if (pl_organizer.inputboxID == 1) {
        pl_organizer.inputbox.on_char(code);
        pl_organizer.searchChars(pl_organizer.inputbox.text);
    }
}
 
 
//// TOOLS ///////
 
function playlist_can_rename(playlistIndex) {
    return !(plman.GetPlaylistLockFilterMask(playlistIndex) & PlaylistLockFilterMask.filter_rename);
}
function playlist_can_add(playlistIndex) {
    return !(plman.GetPlaylistLockFilterMask(playlistIndex) & PlaylistLockFilterMask.filter_add);
}
function playlist_can_remove(playlistIndex) {
    return !(plman.GetPlaylistLockFilterMask(playlistIndex) & PlaylistLockFilterMask.filter_remove_playlist);
}


function sortArray(data, filt, sens) {
    var items = [], idxs = [];
    for (var j = 0; j < data.length; j++) {
        var item = data[j];
        if (item.fold === filt) {
            items.push([item, item.name.toLowerCase()]);
            idxs.push(j);
        }
    }
    items.sort(function (a, b) {
        if (sens)
            return a[1] > b[1] ? 1 : a[1] < b[1] ? -1 : 0;
        else
            return a[1] > b[1] ? -1 : a[1] < b[1] ? 1 : 0;
    });
    // put sorted items back into the data array using collected indices
    var idx = 0;
    for (var j = 0; j < items.length; j++) {
        data[idxs[idx++]] = items[j][0];
    }
    return data;
}
Array.prototype.move = function (from, to) {
    var i, tmp;
    from = parseInt(from, 10);
    to = parseInt(to, 10);
    if (from !== to && 0 <= from && from <= this.length && 0 <= to && to <= this.length) {
        tmp = this[from];
        if (from < to) {
            for (i = from; i <= to; i++) {
                this[i] = this[i + 1];
            }
        }
        else {
            for (i = from; i >= to; i--) { // >=
                this[i] = this[i - 1];
            }
        }
        this[to] = tmp;
    }
    return this[to < 0 ? 0 : to].id;
}
 
function dynamicSort(property) { // convert into numbers with the +
    var sortOrder = 1;
    if (property[0] === "-") {
        sortOrder = -1;
        property = property.substr(1);
    }
    return function (a, b) {
        var result = (+a[property] < +b[property]) ? -1 : (+a[property] > +b[property]) ? 1 : 0;
        return result * sortOrder;
    }
}
 
function niceBytes(x) {
    var l = 0, n = parseInt(x, 10) || 0;
    while (n >= 1024 && ++l) {
        n = n / 1024;
    }
    return (n.toFixed(n < 10 && l > 0 ? 2 : 1) + ' ' + units[l]);
}
 
function millisecondsToStr(sec) {
    var weeks = Math.floor(sec / 604800),
        days = Math.floor((sec %= 604800) / 86400),
        hours = Math.floor((sec %= 86400) / 3600),
        minutes = Math.floor((sec %= 3600) / 60),
        seconds = sec % 60;
 
    if (days || hours || seconds || minutes) {
        return (weeks ? weeks + "wk " : "") +
            (days ? days + "d " : "") +
            (hours ? hours + ":" : "") +
            (minutes ? minutes + ":" : "") +
            Number(seconds).toFixed(0) + "";
    }
 
    return "< 1s";
}
 
 
 
 
//TODOS///////
// mettre le fold id instead of name 
// try to replace the display/data arrays into a multi dimensional array
// unselect
/*
Help section redesign
- Added a help submenu context item with a link to this discussion thread and revised reference manual
Changes:
- Cosmetic
  - Reduced top margin of the playlist panel to this.layerUp = _scale(2);
  - Modified tooltip total duration format to match foobar2000s duration format for UI consistency, and replaced the word "Total" with "Duration" to specifically indicate it's a duration
  - Changed string "normal playlist" to "standard playlist". I've noticed throughout the forums and in a few components/scripts people tend to refer to non-autoplaylists as standard playlist. I just changed the wording here for consistency with that.
- Feature
  - Added a mouse behavior setting to select mouse scroll speed (fast, medium, and slow, where fast is the default and current incumbent speed).
Right click now selects the playlist/folder
Restore playlist (90)
 
purge playlist
 
 
*/