// ==PREPROCESSOR==
// @name "Playlist Organizer"
// @version "2.0.5 date 15/10/2023"
// @author "Seb + inspiration and abstracts from marc2003 + great help from metal_termite."
// @import "%fb2k_component_path%helpers.txt"
// @import "%fb2k_component_path%samples\js\lodash.min.js"
// @import "%fb2k_component_path%samples\js\common.js"
// @import "%fb2k_profile_path%pl_organizer\inputbox.js"
// @import "%fb2k_profile_path%pl_organizer\pl_organizer.js"
// @import "%fb2k_profile_path%pl_organizer\scrollbar.js"
// ==/PREPROCESSOR==


var pl_organizer = new _pl_organizer();
pl_organizer.update();

function on_drag_drop(action, x, y, mask) {
	pl_organizer.on_drag_drop(action, x, y, mask);
}

function on_drag_over(action, x, y, mask) {
	pl_organizer.on_drag_over(action, x, y, mask);
}

function on_colours_changed() {
	pl_organizer.colours_def();
	window.Repaint();
}

function on_font_changed() {
	pl_organizer.font_changed();
	window.Repaint();
}

function on_item_focus_change() {
	window.Repaint();
}

function on_playlists_changed() {
	
	pl_organizer.reset();
	pl_organizer.update();
}
function on_playlist_items_added(playlistIndex) {
	pl_organizer.PLmgt(playlistIndex);
}
function on_playlist_items_removed(playlistIndex, new_count) {
	pl_organizer.PLmgt(playlistIndex);
}
function on_playlist_switch() {
	window.Repaint();
}


function on_key_down(k) {
	pl_organizer.key_down(k);
}

function on_key_up(k) {
	pl_organizer.key_up(k);
}

function on_mouse_lbtn_up(x, y) {
	pl_organizer.lbtn_up(x, y);
}
function on_mouse_lbtn_down(x, y) {
	pl_organizer.lbtn_down(x, y);
}

function on_mouse_move(x, y) {
	pl_organizer.move(x, y);
}

function on_mouse_rbtn_up(x, y) {
	return pl_organizer.rbtn_up(x, y);
}

function on_mouse_lbtn_dblclk(x, y) {
	pl_organizer.lbtn_dblck(x, y);
}

function on_mouse_wheel(s) {
	pl_organizer.wheel(s);
}

function on_paint(gr) {
	pl_organizer.paint(gr);
}
function on_focus(is_focused){
	window.Repaint();
}

function on_playback_stop(reason) {
	pl_organizer.setBkgroundImg();
	window.Repaint();
}

function on_playback_new_track(handle) {
	pl_organizer.setBkgroundImg();
	window.Repaint();
}

function on_size() {

	pl_organizer.size();
}