/*
* SACD Decoder plugin
* Copyright (c) 2011-2023 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

constexpr unsigned char DSD_SILENCE_BYTE = 0x69;

auto constexpr CTABLES = [](auto fir_length) {
	return (fir_length + 7) / 8;
};
constexpr int PCMFIR_OFFSET = 0x7fffffff;
constexpr int PCMFIR_SCALE  = 31;

constexpr int DSDFIR1_8_LENGTH = 80;
constexpr double DSDFIR1_8_COEFS[DSDFIR1_8_LENGTH] = {
	-142,
	-651,
	-1997,
	-4882,
	-10198,
	-18819,
	-31226,
	-46942,
	-63892,
	-77830,
	-82099,
	-67999,
	-26010,
	52003,
	169742,
	323000,
	496497,
	662008,
	778827,
	797438,
	666789,
	344848,
	-188729,
	-919845,
	-1789769,
	-2690283,
	-3466610,
	-3929490,
	-3876295,
	-3119266,
	-1517221,
	994203,
	4379191,
	8490255,
	13072043,
	17781609,
	22223533,
	25995570,
	28738430,
	30182209,
	30182209,
	28738430,
	25995570,
	22223533,
	17781609,
	13072043,
	8490255,
	4379191,
	994203,
	-1517221,
	-3119266,
	-3876295,
	-3929490,
	-3466610,
	-2690283,
	-1789769,
	-919845,
	-188729,
	344848,
	666789,
	797438,
	778827,
	662008,
	496497,
	323000,
	169742,
	52003,
	-26010,
	-67999,
	-82099,
	-77830,
	-63892,
	-46942,
	-31226,
	-18819,
	-10198,
	-4882,
	-1997,
	-651,
	-142,
};

constexpr int DSDFIR1_16_LENGTH = 160;
constexpr double DSDFIR1_16_COEFS[DSDFIR1_16_LENGTH] = {
	-42,
	-102,
	-220,
	-420,
	-739,
	-1220,
	-1914,
	-2878,
	-4171,
	-5851,
	-7967,
	-10555,
	-13625,
	-17154,
	-21075,
	-25266,
	-29539,
	-33636,
	-37219,
	-39874,
	-41114,
	-40390,
	-37108,
	-30659,
	-20450,
	-5948,
	13272,
	37474,
	66704,
	100733,
	139006,
	180597,
	224174,
	267987,
	309866,
	347255,
	377263,
	396750,
	402440,
	391067,
	359534,
	305112,
	225636,
	119722,
	-13034,
	-171854,
	-354614,
	-557713,
	-775985,
	-1002675,
	-1229481,
	-1446662,
	-1643229,
	-1807208,
	-1925973,
	-1986643,
	-1976541,
	-1883674,
	-1697253,
	-1408195,
	-1009619,
	-497293,
	129993,
	870122,
	1717463,
	2662800,
	3693381,
	4793111,
	5942870,
	7120962,
	8303674,
	9465936,
	10582054,
	11626490,
	12574667,
	13403753,
	14093414,
	14626488,
	14989568,
	15173448,
	15173448,
	14989568,
	14626488,
	14093414,
	13403753,
	12574667,
	11626490,
	10582054,
	9465936,
	8303674,
	7120962,
	5942870,
	4793111,
	3693381,
	2662800,
	1717463,
	870122,
	129993,
	-497293,
	-1009619,
	-1408195,
	-1697253,
	-1883674,
	-1976541,
	-1986643,
	-1925973,
	-1807208,
	-1643229,
	-1446662,
	-1229481,
	-1002675,
	-775985,
	-557713,
	-354614,
	-171854,
	-13034,
	119722,
	225636,
	305112,
	359534,
	391067,
	402440,
	396750,
	377263,
	347255,
	309866,
	267987,
	224174,
	180597,
	139006,
	100733,
	66704,
	37474,
	13272,
	-5948,
	-20450,
	-30659,
	-37108,
	-40390,
	-41114,
	-39874,
	-37219,
	-33636,
	-29539,
	-25266,
	-21075,
	-17154,
	-13625,
	-10555,
	-7967,
	-5851,
	-4171,
	-2878,
	-1914,
	-1220,
	-739,
	-420,
	-220,
	-102,
	-42,
};

constexpr int DSDFIR1_64_LENGTH = 641;
constexpr double DSDFIR1_64_COEFS[DSDFIR1_64_LENGTH] = {
	1652, 421, 509, 606, 714, 832,
	960, 1098, 1245, 1402, 1567, 1739,
	1917, 2101, 2287, 2475, 2663, 2848,
	3027, 3199, 3359, 3504, 3632, 3738,
	3818, 3869, 3886, 3864, 3800, 3689,
	3525, 3305, 3024, 2677, 2260, 1769,
	1201, 550, -184, -1006, -1918, -2921,
	-4016, -5203, -6483, -7854, -9314, -10859,
	-12487, -14190, -15965, -17802, -19693, -21630,
	-23600, -25591, -27591, -29584, -31555, -33486,
	-35359, -37155, -38854, -40434, -41872, -43146,
	-44233, -45108, -45747, -46124, -46216, -45997,
	-45443, -44530, -43236, -41537, -39414, -36847,
	-33818, -30310, -26311, -21809, -16796, -11265,
	-5214, 1355, 8439, 16029, 24112, 32673,
	41689, 51136, 60984, 71196, 81734, 92553,
	103603, 114829, 126173, 137571, 148954, 160248,
	171377, 182260, 192811, 202943, 212564, 221581,
	229897, 237417, 244040, 249669, 254204, 257547,
	259603, 260277, 259477, 257115, 253109, 247380,
	239855, 230471, 219167, 205896, 190617, 173299,
	153922, 132479, 108972, 83419, 55848, 26302,
	-5160, -38467, -73531, -110251, -148507, -188168,
	-229083, -271089, -314005, -357638, -401777, -446201,
	-490671, -534940, -578744, -621813, -663865, -704607,
	-743744, -780970, -815977, -848454, -878088, -904566,
	-927580, -946823, -961997, -972811, -978983, -980246,
	-976346, -967047, -952131, -931400, -904681, -871825,
	-832710, -787243, -735363, -677041, -612281, -541124,
	-463648, -379970, -290244, -194666, -93474, 13055,
	124601, 240802, 361256, 485518, 613104, 743490,
	876114, 1010376, 1145641, 1281243, 1416482, 1550632,
	1682939, 1812627, 1938901, 2060949, 2177947, 2289061,
	2393456, 2490292, 2578736, 2657963, 2727161, 2785536,
	2832319, 2866766, 2888167, 2895851, 2889189, 2867598,
	2830552, 2777578, 2708268, 2622279, 2519340, 2399255,
	2261904, 2107255, 1935358, 1746352, 1540469, 1318035,
	1079470, 825295, 556126, 272680, -24227, -333679,
	-654661, -986063, -1326676, -1675201, -2030245, -2390331,
	-2753893, -3119291, -3484807, -3848654, -4208980, -4563877,
	-4911383, -5249495, -5576169, -5889335, -6186898, -6466754,
	-6726792, -6964906, -7179003, -7367014, -7526900, -7656665,
	-7754364, -7818111, -7846090, -7836566, -7787889, -7698508,
	-7566979, -7391970, -7172272, -6906808, -6594638, -6234967,
	-5827149, -5370698, -4865289, -4310766, -3707142, -3054607,
	-2353529, -1604454, -808113, 34585, 922545, 1854492,
	2828973, 3844355, 4898832, 5990428, 7117000, 8276247,
	9465711, 10682788, 11924736, 13188679, 14471619, 15770447,
	17081948, 18402817, 19729666, 21059038, 22387418, 23711244,
	25026925, 26330844, 27619383, 28888926, 30135877, 31356675,
	32547801, 33705799, 34827283, 35908952, 36947604, 37940146,
	38883606, 39775147, 40612074, 41391849, 42112096, 42770616,
	43365391, 43894592, 44356589, 44749958, 45073480, 45326155,
	45507200, 45616052, 45652373, 45616052, 45507200, 45326155,
	45073480, 44749958, 44356589, 43894592, 43365391, 42770616,
	42112096, 41391849, 40612074, 39775147, 38883606, 37940146,
	36947604, 35908952, 34827283, 33705799, 32547801, 31356675,
	30135877, 28888926, 27619383, 26330844, 25026925, 23711244,
	22387418, 21059038, 19729666, 18402817, 17081948, 15770447,
	14471619, 13188679, 11924736, 10682788, 9465711, 8276247,
	7117000, 5990428, 4898832, 3844355, 2828973, 1854492,
	922545, 34585, -808113, -1604454, -2353529, -3054607,
	-3707142, -4310766, -4865289, -5370698, -5827149, -6234967,
	-6594638, -6906808, -7172272, -7391970, -7566979, -7698508,
	-7787889, -7836566, -7846090, -7818111, -7754364, -7656665,
	-7526900, -7367014, -7179003, -6964906, -6726792, -6466754,
	-6186898, -5889335, -5576169, -5249495, -4911383, -4563877,
	-4208980, -3848654, -3484807, -3119291, -2753893, -2390331,
	-2030245, -1675201, -1326676, -986063, -654661, -333679,
	-24227, 272680, 556126, 825295, 1079470, 1318035,
	1540469, 1746352, 1935358, 2107255, 2261904, 2399255,
	2519340, 2622279, 2708268, 2777578, 2830552, 2867598,
	2889189, 2895851, 2888167, 2866766, 2832319, 2785536,
	2727161, 2657963, 2578736, 2490292, 2393456, 2289061,
	2177947, 2060949, 1938901, 1812627, 1682939, 1550632,
	1416482, 1281243, 1145641, 1010376, 876114, 743490,
	613104, 485518, 361256, 240802, 124601, 13055,
	-93474, -194666, -290244, -379970, -463648, -541124,
	-612281, -677041, -735363, -787243, -832710, -871825,
	-904681, -931400, -952131, -967047, -976346, -980246,
	-978983, -972811, -961997, -946823, -927580, -904566,
	-878088, -848454, -815977, -780970, -743744, -704607,
	-663865, -621813, -578744, -534940, -490671, -446201,
	-401777, -357638, -314005, -271089, -229083, -188168,
	-148507, -110251, -73531, -38467, -5160, 26302,
	55848, 83419, 108972, 132479, 153922, 173299,
	190617, 205896, 219167, 230471, 239855, 247380,
	253109, 257115, 259477, 260277, 259603, 257547,
	254204, 249669, 244040, 237417, 229897, 221581,
	212564, 202943, 192811, 182260, 171377, 160248,
	148954, 137571, 126173, 114829, 103603, 92553,
	81734, 71196, 60984, 51136, 41689, 32673,
	24112, 16029, 8439, 1355, -5214, -11265,
	-16796, -21809, -26311, -30310, -33818, -36847,
	-39414, -41537, -43236, -44530, -45443, -45997,
	-46216, -46124, -45747, -45108, -44233, -43146,
	-41872, -40434, -38854, -37155, -35359, -33486,
	-31555, -29584, -27591, -25591, -23600, -21630,
	-19693, -17802, -15965, -14190, -12487, -10859,
	-9314, -7854, -6483, -5203, -4016, -2921,
	-1918, -1006, -184, 550, 1201, 1769,
	2260, 2677, 3024, 3305, 3525, 3689,
	3800, 3864, 3886, 3869, 3818, 3738,
	3632, 3504, 3359, 3199, 3027, 2848,
	2663, 2475, 2287, 2101, 1917, 1739,
	1567, 1402, 1245, 1098, 960, 832,
	714, 606, 509, 421, 1652
};

constexpr int PCMFIR2_2_LENGTH = 27;
constexpr double PCMFIR2_2_COEFS[PCMFIR2_2_LENGTH] = {
	349146,
	0,
	-2503287,
	0,
	10155531,
	0,
	-30459917,
	0,
	76750087,
	0,
	-185782569,
	0,
	668365690,
	1073741824,
	668365690,
	0,
	-185782569,
	0,
	76750087,
	0,
	-30459917,
	0,
	10155531,
	0,
	-2503287,
	0,
	349146,
};

constexpr int PCMFIR3_2_LENGTH = 151;
constexpr double PCMFIR3_2_COEFS[PCMFIR3_2_LENGTH] = {
	-5412,
	0,
	10344,
	0,
	-19926,
	0,
	35056,
	0,
	-57881,
	0,
	91092,
	0,
	-138012,
	0,
	202658,
	0,
	-289823,
	0,
	405153,
	0,
	-555217,
	0,
	747573,
	0,
	-990842,
	0,
	1294782,
	0,
	-1670364,
	0,
	2129866,
	0,
	-2687005,
	0,
	3357104,
	0,
	-4157326,
	0,
	5107022,
	0,
	-6228238,
	0,
	7546440,
	0,
	-9091589,
	0,
	10899739,
	0,
	-13015406,
	0,
	15495180,
	0,
	-18413298,
	0,
	21870494,
	0,
	-26008543,
	0,
	31035142,
	0,
	-37268765,
	0,
	45224971,
	0,
	-55796870,
	0,
	70676173,
	0,
	-93495917,
	0,
	133715464,
	0,
	-226044891,
	0,
	682959923,
	1073741824,
	682959923,
	0,
	-226044891,
	0,
	133715464,
	0,
	-93495917,
	0,
	70676173,
	0,
	-55796870,
	0,
	45224971,
	0,
	-37268765,
	0,
	31035142,
	0,
	-26008543,
	0,
	21870494,
	0,
	-18413298,
	0,
	15495180,
	0,
	-13015406,
	0,
	10899739,
	0,
	-9091589,
	0,
	7546440,
	0,
	-6228238,
	0,
	5107022,
	0,
	-4157326,
	0,
	3357104,
	0,
	-2687005,
	0,
	2129866,
	0,
	-1670364,
	0,
	1294782,
	0,
	-990842,
	0,
	747573,
	0,
	-555217,
	0,
	405153,
	0,
	-289823,
	0,
	202658,
	0,
	-138012,
	0,
	91092,
	0,
	-57881,
	0,
	35056,
	0,
	-19926,
	0,
	10344,
	0,
	-5412,
};

constexpr int PCMFIR4_147_160_LENGTH = 3201;
constexpr double PCMFIR4_147_160_COEFS[PCMFIR4_147_160_LENGTH] = {
	-1.478011657745e-21,-1.103921573337e-09,-2.26016975327e-09,-3.469513113474e-09,
	-4.732696283772e-09,-6.050438705569e-09,-7.423433378541e-09,-8.852345599374e-09,
	-1.033781169334e-08,-1.188043773955e-08,-1.348079829072e-08,-1.513943508834e-08,
	-1.685685577406e-08,-1.863353259836e-08,-2.046990112723e-08,-2.236635894791e-08,
	-2.432326437472e-08,-2.634093515578e-08,-2.841964718183e-08,-3.055963319798e-08,
	-3.276108151957e-08,-3.502413475308e-08,-3.734888852326e-08,-3.973539020746e-08,
	-4.218363767836e-08,-4.469357805612e-08,-4.726510647114e-08,-4.989806483858e-08,
	-5.259224064568e-08,-5.534736575325e-08,-5.816311521229e-08,-6.103910609704e-08,
	-6.397489635575e-08,-6.696998368011e-08,-7.002380439487e-08,-7.313573236867e-08,
	-7.630507794736e-08,-7.953108691109e-08,-8.281293945642e-08,-8.614974920462e-08,
	-8.954056223753e-08,-9.298435616214e-08,-9.648003920522e-08,-1.000264493392e-07,
	-1.036223534409e-07,-1.072664464833e-07,-1.109573507637e-07,-1.146936151668e-07,
	-1.184737144665e-07,-1.22296048666e-07,-1.261589423785e-07,-1.300606442486e-07,
	-1.339993264172e-07,-1.379730840292e-07,-1.419799347878e-07,-1.460178185535e-07,
	-1.500845969916e-07,-1.541780532684e-07,-1.582958917969e-07,-1.62435738034e-07,
	-1.665951383294e-07,-1.707715598289e-07,-1.749623904309e-07,-1.791649387997e-07,
	-1.833764344349e-07,-1.875940277984e-07,-1.918147905012e-07,-1.96035715549e-07,
	-2.002537176493e-07,-2.044656335803e-07,-2.086682226222e-07,-2.128581670532e-07,
	-2.17032072709e-07,-2.211864696087e-07,-2.253178126468e-07,-2.294224823524e-07,
	-2.334967857164e-07,-2.375369570877e-07,-2.415391591381e-07,-2.454994838987e-07,
	-2.494139538657e-07,-2.532785231785e-07,-2.570890788697e-07,-2.608414421874e-07,
	-2.645313699906e-07,-2.681545562181e-07,-2.717066334318e-07,-2.751831744335e-07,
	-2.785796939566e-07,-2.818916504333e-07,-2.851144478361e-07,-2.88243437595e-07,
	-2.912739205905e-07,-2.942011492214e-07,-2.970203295494e-07,-2.997266235181e-07,
	-3.023151512486e-07,-3.047809934096e-07,-3.071191936642e-07,-3.093247611903e-07,
	-3.113926732769e-07,-3.133178779948e-07,-3.15095296941e-07,-3.167198280573e-07,
	-3.181863485222e-07,-3.194897177151e-07,-3.206247802532e-07,-3.215863690993e-07,
	-3.223693087409e-07,-3.229684184388e-07,-3.233785155455e-07,-3.235944188907e-07,
	-3.236109522356e-07,-3.234229477924e-07,-3.230252498094e-07, -3.2241271822e-07,
	-3.215802323549e-07,-3.205226947157e-07,-3.192350348085e-07,-3.177122130371e-07,
	-3.159492246529e-07,-3.139411037615e-07,-3.116829273828e-07,-3.091698195644e-07,
	-3.063969555463e-07,-3.033595659739e-07,-3.000529411594e-07,-2.964724353883e-07,
	-2.926134712696e-07,-2.884715441273e-07,-2.840422264323e-07,-2.793211722704e-07,
	-2.743041218471e-07,-2.689869060234e-07,-2.633654508841e-07,-2.574357823334e-07,
	-2.511940307162e-07,-2.446364354635e-07,-2.377593497576e-07,-2.305592452167e-07,
	-2.230327165937e-07,-2.15176486489e-07,-2.069874100729e-07,-1.984624798146e-07,
	-1.89598830217e-07,-1.803937425514e-07,-1.708446495921e-07,-1.60949140345e-07,
	-1.507049647696e-07,-1.401100384902e-07,-1.291624474925e-07,-1.178604528039e-07,
	-1.062024951526e-07,-9.418719960394e-08,-8.18133801689e-08,-6.908004438279e-08,
	-5.598639784987e-08,-4.253184875085e-08,-2.871601230967e-08,-1.453871521598e-08,
	8.262514961441e-22,1.489987064413e-08,3.016040958979e-08,4.578090106798e-08,
	6.176039651961e-08,7.809771051362e-08,9.479141673474e-08,1.118398440445e-07,
	1.292410726192e-07,1.469929301688e-07,1.650929882399e-07,1.835385586076e-07,
	2.023266897586e-07,2.214541634706e-07,2.409174914915e-07,2.607129123208e-07,
	2.808363880996e-07,3.012836016101e-07,3.220499533909e-07,3.431305589695e-07,
		3.64520246218e-07,3.862135528337e-07,4.082047239503e-07,4.304877098808e-07,
	4.530561639992e-07, 4.75903440761e-07, 4.99022593869e-07,5.224063745864e-07,
	5.460472302012e-07,5.699373026453e-07,5.940684272724e-07,6.184321317972e-07,
	6.430196353996e-07,6.678218479981e-07,6.928293696941e-07,7.180324903919e-07,
	7.434211895969e-07,7.689851363948e-07,7.947136896154e-07,8.205958981845e-07,
	8.466205016653e-07,8.727759309939e-07,8.990503094105e-07,9.254314535898e-07,
	9.519068749728e-07,9.784637813029e-07,1.005089078368e-06,1.031769371955e-06,
	1.058490970007e-06,1.085239885007e-06,1.112001836568e-06,1.138762254241e-06,
		1.16550628055e-06,1.192218774241e-06,1.218884313759e-06,1.245487200948e-06,
		1.27201146498e-06,1.298440866509e-06,1.324758902057e-06,1.350948808629e-06,
	1.376993568561e-06,1.402875914598e-06,1.428578335213e-06,1.454083080148e-06,
	1.479372166201e-06,1.504427383241e-06,1.529230300467e-06,1.553762272889e-06,
	1.578004448062e-06,1.601937773042e-06,1.625543001581e-06,1.648800701566e-06,
	1.671691262677e-06,1.694194904295e-06, 1.71629168363e-06,1.737961504093e-06,
	1.759184123887e-06, 1.77993916484e-06,1.800206121457e-06,1.819964370206e-06,
	1.839193179025e-06,1.857871717051e-06,1.875979064577e-06,1.893494223224e-06,
	1.910396126326e-06,1.926663649536e-06,1.942275621642e-06, 1.95721083559e-06,
		1.97144805971e-06,1.984966049153e-06,1.997743557521e-06, 2.00975934869e-06,
	2.020992208836e-06,2.031420958636e-06,2.041024465664e-06,2.049781656961e-06,
	2.057671531781e-06,2.064673174513e-06,2.070765767763e-06,2.075928605603e-06,
	2.080141106972e-06,2.083382829234e-06,2.085633481879e-06,2.086872940362e-06,
	2.087081260084e-06,2.086238690496e-06,2.084325689329e-06,2.081322936941e-06,
	2.077211350773e-06,2.071972099913e-06,2.065586619755e-06,2.058036626747e-06,
		2.04930413323e-06,2.039371462344e-06,2.028221263015e-06,2.015836524995e-06,
	2.002200593961e-06, 1.98729718666e-06,1.971110406098e-06,1.953624756754e-06,
	1.934825159817e-06, 1.91469696845e-06,1.893225983043e-06,1.870398466481e-06,
	1.846201159391e-06,1.820621295376e-06,1.793646616219e-06, 1.76526538705e-06,
	1.735466411473e-06,1.704239046626e-06,1.671573218195e-06,1.637459435337e-06,
	1.601888805531e-06,1.564853049338e-06,1.526344515048e-06, 1.48635619323e-06,
	1.444881731151e-06,1.401915447066e-06, 1.35745234437e-06,1.311488125597e-06,
	1.264019206258e-06,1.215042728507e-06,1.164556574629e-06,1.112559380335e-06,
	1.059050547853e-06,1.004030258816e-06,9.474994869131e-07,8.894600103255e-07,
	8.299144239063e-07,7.688661511145e-07,7.063194556839e-07,6.422794530186e-07,
	5.767521213042e-07,5.097443123255e-07,4.412637619792e-07,3.713191004725e-07,
	2.999198621958e-07,2.270764952611e-07,1.528003706946e-07,7.710379127398e-08,
	-3.882092462702e-21,-7.849681180708e-08,-1.583714967968e-07,-2.396079442732e-07,
	-3.221890732841e-07,-4.06096826126e-07,-4.913121622721e-07,-5.77815052736e-07,
	-6.655844748768e-07,-7.545984076577e-07,-8.448338273668e-07,-9.362667038073e-07,
	-1.028871996969e-06,-1.122623654186e-06,-1.217494607794e-06,-1.313456773292e-06,
	-1.410481048018e-06,-1.508537310342e-06, -1.6075944194e-06,-1.707620215356e-06,
	-1.80858152021e-06,-1.910444139164e-06,-2.013172862543e-06,-2.116731468286e-06,
	-2.221082725009e-06,-2.326188395648e-06,-2.432009241691e-06,-2.538505027998e-06,
	-2.645634528225e-06,-2.753355530851e-06,-2.861624845807e-06,-2.970398311736e-06,
	-3.079630803851e-06,-3.18927624244e-06,-3.299287601978e-06,-3.40961692089e-06,
	-3.520215311936e-06,-3.631032973241e-06,-3.742019199975e-06,-3.853122396662e-06,
	-3.964290090154e-06,-4.075468943246e-06,-4.186604768945e-06,-4.297642545392e-06,
	-4.408526431442e-06,-4.519199782897e-06,-4.629605169399e-06,-4.739684391972e-06,
	-4.849378501231e-06,-4.95862781624e-06,-5.067371944025e-06,-5.175549799745e-06,
	-5.283099627514e-06,-5.389959021872e-06,-5.496064949901e-06,-5.601353773999e-06,
	-5.705761275277e-06,-5.809222677614e-06,-5.911672672333e-06,-6.013045443514e-06,
	-6.113274693936e-06,-6.212293671627e-06,-6.31003519705e-06,-6.406431690877e-06,
	-6.501415202382e-06,-6.594917438427e-06,-6.686869793029e-06,-6.777203377527e-06,
	-6.865849051302e-06,-6.952737453084e-06,-7.037799032801e-06,-7.120964083981e-06,
	-7.202162776699e-06,-7.281325191044e-06,-7.358381351109e-06,-7.433261259492e-06,
	-7.505894932282e-06,-7.576212434548e-06,-7.644143916285e-06,-7.709619648828e-06,
	-7.772570061719e-06,-7.832925779995e-06,-7.890617661914e-06,-7.945576837072e-06,
	-7.997734744931e-06,-8.047023173705e-06,-8.093374299629e-06,-8.136720726559e-06,
	-8.176995525914e-06,-8.214132276933e-06,-8.24806510722e-06,-8.278728733587e-06,
	-8.306058503149e-06,-8.329990434667e-06,-8.350461260127e-06,-8.367408466519e-06,
	-8.380770337814e-06,-8.390485997108e-06,-8.396495448925e-06,-8.398739621644e-06,
	-8.397160410044e-06,-8.391700717941e-06,-8.382304500895e-06,-8.368916808963e-06,
	-8.351483829492e-06,-8.329952929904e-06,-8.304272700478e-06,-8.274392997093e-06,
	-8.240264983905e-06,-8.201841175946e-06,-8.159075481625e-06,-8.111923245084e-06,
	-8.060341288421e-06,-8.004287953722e-06,-7.943723144904e-06,-7.87860836933e-06,
	-7.808906779179e-06,-7.73458321254e-06,-7.655604234217e-06,-7.571938176204e-06,
	-7.483555177823e-06,-7.390427225484e-06,-7.292528192051e-06,-7.189833875791e-06,
	-7.082322038871e-06,-6.969972445386e-06,-6.852766898889e-06,-6.730689279398e-06,
	-6.603725579857e-06,-6.471863942019e-06,-6.335094691732e-06,-6.193410373602e-06,
	-6.046805785001e-06,-5.895278009399e-06,-5.738826449001e-06,-5.577452856647e-06,
	-5.411161366966e-06,-5.23995852675e-06,-5.063853324523e-06,-4.882857219284e-06,
	-4.696984168396e-06,-4.506250654594e-06,-4.310675712096e-06,-4.110280951775e-06,
	-3.905090585392e-06,-3.69513144884e-06,-3.480433024401e-06,-3.261027461965e-06,
	-3.036949599208e-06, -2.8082369807e-06,-2.574929875918e-06,-2.337071296134e-06,
	-2.094707010178e-06,-1.847885559026e-06,-1.596658269211e-06,-1.341079265026e-06,
	-1.081205479509e-06,-8.170966641633e-07,-5.488153974313e-07,-2.764270918656e-07,
	1.215581681048e-20,2.803947811071e-07,5.646833066743e-07,8.527887823615e-07,
	1.144631563815e-06,1.440129157612e-06,1.739196223617e-06,2.041744578773e-06,
	2.347683202335e-06,2.656918242571e-06,2.969353024935e-06,3.284888061734e-06,
	3.603421063294e-06,3.924846950649e-06,4.249057869757e-06,4.575943207253e-06,
	4.905389607759e-06,5.237280992754e-06,5.571498581014e-06,5.907920910635e-06,
	6.246423862642e-06,6.586880686199e-06,6.929162025416e-06, 7.27313594777e-06,
	7.618667974139e-06,7.965621110457e-06,8.313855880987e-06,8.663230363227e-06,
		9.01360022444e-06,9.364818759816e-06,9.716736932261e-06,1.006920341383e-05,
	1.042206462875e-05,1.077516479815e-05,1.112834598633e-05,1.148144814867e-05,
	1.183430918125e-05,1.218676497191e-05, 1.25386494531e-05, 1.28897946562e-05,
	1.324003076745e-05,1.358918618557e-05,1.393708758079e-05,1.428355995557e-05,
	1.462842670681e-05,1.497150968963e-05,1.531262928263e-05,1.565160445475e-05,
	1.598825283352e-05,1.632239077488e-05,1.665383343439e-05,1.698239483998e-05,
	1.730788796601e-05,1.763012480885e-05,1.794891646379e-05,1.826407320328e-05,
	1.857540455665e-05,1.888271939097e-05,1.918582599336e-05,1.948453215447e-05,
	1.977864525328e-05,2.006797234304e-05,2.035232023849e-05,2.063149560416e-05,
	2.090530504388e-05,2.117355519127e-05,2.143605280149e-05,2.169260484382e-05,
		2.19430185954e-05,2.218710173585e-05,2.242466244289e-05, 2.26555094888e-05,
	2.287945233778e-05,2.309630124415e-05,2.330586735127e-05,2.350796279128e-05,
	2.370240078553e-05,2.388899574565e-05,2.406756337526e-05, 2.42379207723e-05,
	2.439988653182e-05,2.455328084937e-05,2.469792562475e-05,2.483364456621e-05,
	2.496026329503e-05,2.507760945037e-05,2.518551279443e-05,2.528380531776e-05,
	2.537232134487e-05,2.545089763982e-05,2.551937351195e-05,2.557759092165e-05,
	2.562539458608e-05,2.566263208475e-05,2.568915396511e-05,2.570481384779e-05,
	2.570946853173e-05,2.570297809895e-05,2.568520601899e-05,2.565601925295e-05,
	2.561528835711e-05,2.556288758597e-05,2.549869499479e-05,2.542259254148e-05,
	2.533446618783e-05,2.523420599995e-05,2.512170624803e-05,2.499686550513e-05,
	2.485958674519e-05,2.470977743995e-05,2.454734965498e-05,2.437222014451e-05,
	2.418431044526e-05,2.398354696897e-05,2.376986109372e-05,2.354318925397e-05,
	2.330347302921e-05,2.305065923119e-05,2.278469998968e-05,2.250555283668e-05,
	2.221318078908e-05,2.190755242961e-05,2.158864198612e-05, 2.12564294091e-05,
	2.091090044737e-05,2.055204672187e-05,2.017986579757e-05,1.979436125337e-05,
	1.939554274992e-05, 1.89834260954e-05,1.855803330915e-05,1.811939268302e-05,
	1.766753884053e-05,1.720251279372e-05,1.672436199761e-05,1.623314040226e-05,
	1.572890850232e-05,1.521173338415e-05,1.468168877031e-05,1.413885506144e-05,
	1.358331937551e-05,1.301517558431e-05,1.243452434725e-05,1.184147314228e-05,
	1.123613629404e-05,1.061863499904e-05,9.989097347999e-06,9.347658345097e-06,
	8.694459924315e-06,8.029650962647e-06,7.353387290249e-06,6.665831697435e-06,
	5.967153938519e-06,5.257530732439e-06, 4.53714576014e-06, 3.80618965869e-06,
	3.064860012082e-06,2.313361338701e-06,1.551905075428e-06,7.807095583408e-07,
	-2.939120998031e-20,-7.899915367138e-07,-1.589026168236e-06,-2.39685822345e-06,
	-3.213235280325e-06,-4.037898206105e-06,-4.870581201034e-06,-5.711011845666e-06,
	-6.558911151751e-06,-7.413993616723e-06,-8.275967281802e-06,-9.144533793713e-06,
	-1.001938847004e-05,-1.090022036822e-05,-1.178671235817e-05,-1.267854119856e-05,
	-1.357537761678e-05,-1.447688639248e-05,-1.53827264448e-05,-1.62925509233e-05,
	-1.720600730241e-05,-1.812273747962e-05,-1.904237787724e-05,-1.996455954782e-05,
	-2.088890828312e-05,-2.18150447267e-05,-2.27425844901e-05,-2.367113827255e-05,
	-2.460031198424e-05,-2.552970687306e-05,-2.645891965493e-05,-2.738754264746e-05,
	-2.83151639072e-05,-2.924136737018e-05,-3.01657329959e-05,-3.108783691466e-05,
	-3.200725157819e-05,-3.292354591358e-05,-3.38362854804e-05,-3.474503263109e-05,
	-3.564934667447e-05,-3.654878404235e-05,-3.744289845923e-05,-3.833124111503e-05,
	-3.921336084076e-05,-4.008880428712e-05, -4.0957116106e-05,-4.181783913469e-05,
	-4.267051458299e-05,-4.351468222285e-05,-4.434988058081e-05,-4.517564713283e-05,
	-4.59915185018e-05,-4.679703065734e-05,-4.759171911807e-05,-4.837511915614e-05,
	-4.914676600397e-05,-4.990619506316e-05,-5.065294211553e-05,-5.138654353606e-05,
	-5.210653650782e-05,-5.281245923874e-05,-5.350385118012e-05,-5.418025324684e-05,
	-5.484120803912e-05,-5.548626006582e-05,-5.611495596916e-05,-5.672684475075e-05,
	-5.732147799882e-05,-5.789841011669e-05,-5.845719855219e-05,-5.899740402807e-05,
	-5.951859077328e-05,-6.002032675497e-05,-6.050218391118e-05,-6.096373838407e-05,
	-6.140457075362e-05,-6.182426627164e-05,-6.222241509606e-05,-6.25986125254e-05,
	-6.295245923314e-05,-6.328356150218e-05,-6.359153145901e-05,-6.38759873076e-05,
	-6.413655356295e-05,-6.437286128401e-05,-6.458454830613e-05,-6.47712594726e-05,
	-6.493264686548e-05,-6.506837003537e-05,-6.517809623012e-05,-6.526150062237e-05,
	-6.531826653577e-05,-6.53480856697e-05,-6.535065832253e-05,-6.532569361318e-05,
	-6.527290970089e-05,-6.519203400305e-05,-6.508280341112e-05,-6.494496450429e-05,
	-6.477827376095e-05,-6.458249776778e-05,-6.435741342631e-05,-6.41028081569e-05,
	-6.381848009998e-05,-6.350423831441e-05,-6.315990297296e-05,-6.278530555457e-05,
	-6.238028903352e-05,-6.19447080652e-05,-6.147842916854e-05,-6.098133090474e-05,
	-6.045330405249e-05,-5.989425177928e-05,-5.930408980888e-05,-5.868274658476e-05,
	-5.803016342946e-05,-5.734629469962e-05,-5.663110793676e-05,-5.588458401353e-05,
	-5.51067172754e-05,-5.429751567776e-05,-5.34570009181e-05,-5.25852085634e-05,
	-5.168218817253e-05,-5.074800341348e-05,-4.978273217547e-05,-4.878646667574e-05,
	-4.775931356093e-05,-4.670139400296e-05,-4.561284378939e-05,-4.449381340802e-05,
	-4.334446812575e-05,-4.21649880616e-05,-4.095556825375e-05,-3.971641872055e-05,
	-3.844776451542e-05,-3.714984577552e-05,-3.582291776421e-05,-3.446725090703e-05,
	-3.308313082139e-05,-3.16708583396e-05,-3.023074952544e-05,-2.876313568403e-05,
	-2.726836336497e-05,-2.574679435875e-05,-2.419880568626e-05,-2.262478958147e-05,
	-2.102515346707e-05,-1.940031992318e-05,-1.775072664899e-05,-1.607682641721e-05,
	-1.437908702151e-05,-1.265799121663e-05,-1.091403665134e-05,-9.147735794096e-06,
	-7.359615851415e-06,-5.550218678901e-06,-3.720100684908e-06,-1.869832726835e-06,
			5.861030723e-20,1.888798080899e-06,3.795948007764e-06,5.720822312529e-06,
	7.662779708042e-06,9.621165236414e-06,1.159531042483e-05, 1.35845334488e-05,
	1.558813930294e-05,1.760541997906e-05,1.963565465185e-05,2.167810987185e-05,
	2.373203976589e-05,2.579668624489e-05,2.787127921901e-05,2.995503682011e-05,
	3.204716563148e-05,3.414686092488e-05,3.625330690472e-05,3.836567695944e-05,
	4.048313391999e-05,4.260483032536e-05,4.472990869519e-05, 4.68575018092e-05,
	4.898673299365e-05,5.111671641449e-05,5.324655737737e-05,5.537535263424e-05,
	5.750219069659e-05,5.962615215524e-05,6.174631000645e-05,6.386172998452e-05,
	6.597147090054e-05,6.807458498733e-05,7.017011825045e-05,7.225711082514e-05,
	7.433459733912e-05,7.640160728115e-05, 7.84571653752e-05, 8.05002919601e-05,
	8.253000337463e-05,8.454531234784e-05,8.654522839452e-05, 8.85287582157e-05,
	9.049490610397e-05,9.244267435356e-05,9.437106367507e-05,9.627907361455e-05,
	9.816570297696e-05,0.0001000299502538,0.0001018708140545,0.0001036872935423,
	0.0001054783888729,0.0001072431016372,0.0001089804353076,0.0001106893956869,
	0.0001123689913605,0.0001140182341515,0.0001156361395786, 0.000117221727316,
		0.000118774021656,0.0001202920519738,0.0001217748531937,0.0001232214662576,
		0.000124630938595,0.0001260023245939,0.0001273346860733,0.0001286270927565,
	0.0001298786227451, 0.000131088362994,0.0001322554097856,0.0001333788692059,
	0.0001344578576189,0.0001354915021415, 0.000136478941118,0.0001374193245935,
	0.0001383118147869, 0.000139155586562,0.0001399498278983,0.0001406937403589,
	0.0001413865395582,0.0001420274556261, 0.000142615733671,  0.00014315063424,
		0.000143631433776,0.0001440574250728,0.0001444279177263,0.0001447422385827,
	0.0001449997321831,0.0001451997612043,0.0001453417068954,0.0001454249695105,
	0.0001454489687365,0.0001454131441166,0.0001453169554684,0.0001451598832976,
	0.0001449414292054,0.0001446611162912,0.0001443184895483,0.0001439131162554,
	0.0001434445863595,0.0001429125128545,0.0001423165321514, 0.000141656304443,
	0.0001409315140599,0.0001401418698207,0.0001392871053736,0.0001383669795304,
	0.0001373812765929,0.0001363298066705,0.0001352124059898,0.0001340289371957,
	0.0001327792896431,  0.00013146337968,0.0001300811509214,0.0001286325745134,
	0.0001271176493884,0.0001255364025095, 0.000123888889106,0.0001221751928976,
	0.0001203954263093,0.0001185497306751,0.0001166382764308, 0.000114661263297,
	0.0001126189204496,0.0001105115066802,0.0001083393105445,0.0001061026504993,
	0.0001038018750283,0.0001014373627549, 9.90095225444e-05,9.651879359277e-05,
	9.396564550418e-05,9.135057835547e-05,8.867412274834e-05,8.593683984882e-05,
	8.313932141396e-05,8.028218980561e-05,7.736609799116e-05,7.439172953125e-05,
	7.135979855413e-05,6.827104971681e-05,6.512625815271e-05,6.192622940589e-05,
	5.867179935168e-05,5.536383410358e-05,5.200322990655e-05,4.859091301645e-05,
		4.51278395656e-05, 4.16149954145e-05,3.805339598955e-05,3.444408610679e-05,
	3.078813978162e-05,2.708666002442e-05, 2.33407786221e-05,1.955165590556e-05,
	1.572048050299e-05,1.184846907904e-05,7.936866059914e-06,3.986943344262e-06,
	-9.991828735722e-20,-4.022638052985e-06,-8.079618374202e-06,-1.216956234797e-05,
	-1.629106554284e-05,-2.044269808501e-05,-2.462300504561e-05,-2.88305068419e-05,
	-3.306369965227e-05,-3.732105584492e-05,-4.160102442029e-05,-4.590203146699e-05,
	-5.022248063126e-05,-5.456075359985e-05,-5.891521059616e-05,-6.328419088959e-05,
	-6.766601331798e-05,-7.205897682298e-05,-7.646136099832e-05,-8.087142665066e-05,
	-8.528741637317e-05,-8.970755513135e-05,-9.413005086124e-05,-9.855309507971e-05,
	-0.0001029748635066,-0.0001073935166989,-0.0001118072006959,-0.0001162140476767,
	-0.0001206121766282,-0.000124999694024,-0.000129374694515,-0.0001337352616297,
	-0.0001380794684853,-0.0001424053785088,-0.0001467110461686,-0.0001509945177148,
		-0.00015525383193,-0.0001594870208886,-0.0001636921107255,-0.0001678671224135,
	-0.0001720100725485,-0.0001761189741443,-0.0001801918374336,-0.0001842266706781,
	-0.0001882214809851,-0.0001921742751313,-0.0001960830603939,-0.0001999458453875,
	-0.0002037606409072,-0.0002075254607785,-0.0002112383227114,-0.0002148972491608,
	-0.0002185002681912,-0.0002220454143461,-0.0002255307295221,-0.0002289542638462,
	-0.000232314076557,-0.0002356082368895,-0.0002388348249619,-0.000241991932666,
	-0.0002450776645588,-0.0002480901387564,-0.0002510274878296,-0.0002538878596999,
	-0.0002566694185367,-0.0002593703456548,-0.0002619888404118,-0.0002645231211051,
	-0.0002669714258679,-0.0002693320135645,-0.0002716031646837,-0.0002737831822303,
	-0.0002758703926144,-0.0002778631465379,-0.0002797598198776,-0.0002815588145655,
	-0.0002832585594645,-0.0002848575112402,-0.0002863541552278,-0.000287747006294,
	-0.0002890346096935,-0.0002902155419194,-0.0002912884115475,-0.0002922518600736,
	-0.0002931045627445,-0.0002938452293803,-0.0002944726051896,-0.0002949854715768,
	-0.0002953826469395,-0.0002956629874579,-0.0002958253878739,-0.0002958687822615,
	-0.0002957921447853,-0.0002955944904498,-0.0002952748758367,-0.0002948323998314,
	-0.000294266204337,-0.0002935754749767,-0.0002927594417836,-0.0002918173798765,
	-0.000290748610124,-0.0002895524997934,-0.0002882284631864,-0.0002867759622596,
	-0.0002851945072314,-0.0002834836571718,-0.0002816430205788,-0.0002796722559371,
	-0.0002775710722616,-0.000275339229624,-0.0002729765396622,-0.000270482866073,
	-0.0002678581250867,-0.0002651022859241,-0.0002622153712348,-0.0002591974575175,
	-0.0002560486755212,-0.0002527692106269,-0.0002493593032104,-0.000245819248985,
	-0.0002421493993241,-0.0002383501615637,-0.000234421999284,-0.0002303654325704,
	-0.0002261810382533,-0.0002218694501267,-0.0002174313591443,-0.0002128675135953,
	-0.0002081787192564,-0.0002033658395228,-0.0001984297955161,-0.0001933715661692,
	-0.0001881921882892,-0.0001828927565957,-0.0001774744237374,-0.0001719384002842,
	-0.0001662859546958,-0.0001605184132664,-0.0001546371600463,-0.000148643636738,
	-0.000142539342569,-0.0001363258341403,-0.0001300047252498,-0.0001235776866917,
	-0.0001170464460308,-0.0001104127873527,-0.0001036785509881,-9.684563321343e-05,
	-8.991598592561e-05,-8.289161629226e-05,-7.57745863767e-05,-6.856701273803e-05,
	-6.127106600599e-05,-5.388897043084e-05,-4.642300340812e-05,-3.887549497835e-05,
	-3.124882730171e-05,-2.354543410767e-05,-1.576780011972e-05,-7.918460455146e-06,
	1.487944084201e-19,7.984947240704e-06,1.603369881747e-05,2.414352453536e-05,
	3.231164717755e-05,4.053524325314e-05, 4.88114437693e-05,5.713733502739e-05,
		6.55099594431e-05,7.392631639027e-05,8.238336306837e-05,9.087801539336e-05,
		9.94071489118e-05,0.0001079675997379,0.0001165561655134,0.0001251696063902,
		0.000133804646035,0.0001424579726562,0.0001511262400528,0.0001598060686846,
	0.0001684940467637,0.0001771867313673,0.0001858806495709,0.0001945722996018,
	0.0002032581520135,0.0002119346508784,0.0002205982150013,0.0002292452391514,
	0.0002378720953125,0.0002464751339526,0.0002550506853108,0.0002635950607014,
	0.0002721045538364,0.0002805754421632,0.0002890039882202,0.0002973864410071,
	0.0003057190373712,0.0003139980034093,0.0003222195558828,0.0003303799036484,
	0.0003384752491018,0.0003465017896343, 0.000354455719103,0.0003623332293121,
	0.0003701305115072,0.0003778437578794,0.0003854691630815,0.0003930029257532,
	0.0004004412500569,0.0004077803472216,0.0004150164370966, 0.000422145749712,
	0.0004291645268472,0.0004360690236068,0.0004428555100017,0.0004495202725369,
		0.000456059615804,0.0004624698640785,0.0004687473629208,0.0004748884807809,
	0.0004808896106058,0.0004867471714487,0.0004924576100807,0.0004980174026024,
	0.0005034230560562, 0.000508671110039,0.0005137581383126, 0.000518680750414,
	0.0005234355932625,0.0005280193527643,0.0005324287554141,0.0005366605698917,
	0.0005407116086544,0.0005445787295244,0.0005482588372693,0.0005517488851765,
	0.0005550458766201,0.0005581468666198,0.0005610489633913,0.0005637493298874,
		0.000566245185329,0.0005685338067253,0.0005706125303838, 0.000572478753407,
	0.0005741299351778,0.0005755635988306,0.0005767773327099,0.0005777687918129,
	0.0005785356992184,0.0005790758474989, 0.000579387100117,0.0005794673928043,
	0.0005793147349228,0.0005789272108083,0.0005783029810944,0.0005774402840172,
	0.0005763374366999,0.0005749928364166,0.0005734049618347,0.0005715723742352,
	0.0005694937187107,0.0005671677253399,0.0005645932103387,0.0005617690771867,
	0.0005586943177291,0.0005553680132523,0.0005517893355348,0.0005479575478704,
	0.0005438720060645,0.0005395321594032,0.0005349375515936,0.0005300878216756,
	0.0005249827049044,0.0005196220336036,0.0005140057379874,0.0005081338469524,
	0.0005020064888385,0.0004956238921573,0.0004889863862889,0.0004820944021463,
	0.0004749484728062,0.0004675492341065,0.0004598974252099,0.0004519938891336,
	0.0004438395732435,0.0004354355297139,0.0004267829159517,0.0004178829949843,
	0.0004087371358119,0.0003993468137228,0.0003897136105723,0.0003798392150237,
	0.0003697254227527,0.0003593741366136,0.0003487873667671,0.0003379672307705,
	0.0003269159536289,0.0003156358678076,0.0003041294132056,  0.00029239913709,
	0.0002804476939905,0.0002682778455549,0.0002558924603641,0.0002432945137081,
	0.0002304870873207,0.0002174733690753,0.0002042566526396,0.0001908403370896,
	0.0001772279264841,0.0001634230293981, 0.000149429358415,0.0001352507295795,
	0.0001208910618083,0.0001063543762617,9.164479567304e-05,7.676654363855e-05,
	6.172394386616e-05,4.652141938383e-05,3.116349170741e-05,1.565477996819e-05,
	-1.961712020187e-19,-1.579603661367e-05,-3.17284235327e-05,-4.779216069324e-05,
	-6.398215538024e-05,-8.029322333966e-05,-9.672008992989e-05,-0.0001132573913124,
	-0.000129899675681,-0.0001466414045306,-0.0001634769539629,-0.0001804006160317,
	-0.0001974066001253,-0.0002144890343863,-0.0002316419671689,-0.0002488593685332,
	-0.0002661351317754,-0.0002834630749952,-0.0003008369426975,-0.0003182504074309,
	-0.0003356970714603,-0.0003531704684742,-0.0003706640653265,-0.0003881712638108,
	-0.0004056854024697,-0.0004231997584346,-0.0004407075492996,-0.0004582019350257,
	-0.0004756760198769,-0.0004931228543864,-0.0005105354373532,-0.000527906717868,
	-0.0005452295973679,-0.0005624969317193,-0.0005797015333288,-0.0005968361732809,
	-0.0006138935835021,-0.0006308664589509,-0.0006477474598324,-0.0006645292138384,
	-0.0006812043184101,-0.0006977653430241,-0.0007142048315016,-0.000730515304338,
	-0.0007466892610541,-0.0007627191825674,-0.0007785975335826,-0.0007943167650007,
	-0.0008098693163462,-0.0008252476182114,-0.0008404440947164,-0.0008554511659856,
	-0.0008702612506378,-0.0008848667682909,-0.0008992601420797,-0.0009134338011848,
	-0.0009273801833745,-0.0009410917375559,-0.0009545609263364,-0.0009677802285934,
	-0.0009807421420524,-0.0009934391858719,-0.001005863903235,-0.001018008863944,
	-0.001029866667024,-0.001041429943324,-0.001052691358127,-0.001063643613756,
	-0.001074279452183,-0.001084591657639,-0.001094573059223,-0.001104216533505,
	-0.001113515007131,-0.001122461459423, -0.00113104892497,-0.001139270496218,
	-0.001147119326055, -0.00115458863038,-0.001161671690671,-0.001168361856543,
	-0.001174652548291,-0.001180537259424,-0.001186009559192,-0.001191063095089,
	-0.001195691595351,-0.001199888871434,-0.001203648820482,-0.001206965427765,
	-0.001209832769116, -0.00121224501334,-0.001214196424598,-0.001215681364784,
	-0.001216694295869,-0.001217229782229,-0.001217282492946,-0.001216847204084,
	-0.001215918800949,-0.001214492280307,-0.001212562752591, -0.00121012544407,
	-0.001207175698995, -0.00120370898171,-0.001199720878739,-0.001195207100838,
	-0.001190163485014,-0.001184585996517,-0.001178470730789,-0.001171813915389,
	-0.001164611911875,-0.001156861217653,-0.001148558467788,-0.001139700436782,
	-0.001130284040306,-0.001120306336898,-0.001109764529622,-0.001098655967683,
	-0.001086978148004,-0.001074728716758, -0.00106190547086,-0.001048506359416,
	-0.001034529485124,-0.001019973105637,-0.001004835634875,-0.0009891156442944,
		-0.00097281186411,-0.0009559231844705,-0.0009384486565858,-0.0009203874938075,
	-0.000901739072659,-0.0008825029338185,-0.0008626787830505,-0.0008422664920887,
	-0.0008212660994676,-0.0007996778113027,-0.0007775020020203,-0.0007547392150344,
	-0.0007313901633718,-0.0007074557302446,-0.0006829369695691,-0.0006578351064322,
	-0.000632151537503,-0.0006058878313912,-0.0005790457289508,-0.0005516271435292,
	-0.0005236341611617,-0.0004950690407101,-0.0004659342139471,-0.0004362322855842,
	-0.0004059660332443,-0.0003751384073785,-0.0003437525311267,-0.0003118117001219,
	-0.0002793193822386,-0.0002462792172847,-0.0002126950166368,-0.0001785707628196,
	-0.0001439106090279,-0.0001087188785933,-7.300006439314e-05,-3.675882820441e-05,
		2.30871393056e-19,3.727142281056e-05,7.505027619683e-05,0.0001133312303792,
	0.0001521087907568,0.0001913772988908,0.0002311309335435,0.0002713637117733,
		0.000312069490084,0.0003532419656301,0.0003948746774756,0.0004369610079083,
	0.0004794941838078,0.0005224672780673, 0.000565873211069,0.0006097047522125,
	0.0006539545214959,0.0006986149911499,0.0007436784873226,0.0007891371918172,
	0.0008349831438799,0.0008812082420383,0.0009278042459905,0.0009747627785437,
		0.001022075327601, 0.001069733248198, 0.001117727764586, 0.001166049972365,
		0.001214690840658, 0.001263641214341, 0.001312891816305, 0.001362433249779,
		0.001412256000682, 0.001462350440029, 0.001512706826373, 0.001563315308297,
		0.001614165926936, 0.001665248618552, 0.001716553217137, 0.001768069457068,
		0.001819786975786, 0.001871695316523, 0.001923783931063, 0.001976042182534,
		0.002028459348242, 0.002081024622537, 0.002133727119705, 0.002186555876903,
		0.00223949985712, 0.002292547952167, 0.002345688985698, 0.002398911716261,
		0.002452204840377, 0.002505556995639, 0.002558956763844,  0.00261239267415,
		0.002665853206247, 0.002719326793564, 0.002772801826486, 0.002826266655598,
		0.002879709594947, 0.002933118925322, 0.002986482897551, 0.003039789735814,
		0.003093027640977, 0.003146184793927, 0.003199249358937, 0.003252209487027,
		0.003305053319348,  0.00335776899057, 0.003410344632277, 0.003462768376376,
		0.003515028358506, 0.003567112721455, 0.003619009618583, 0.003670707217244,
		0.003722193702214, 0.003773457279116, 0.003824486177847, 0.003875268656005,
		0.003925793002309, 0.003976047540018, 0.004026020630345, 0.004075700675867,
		0.004125076123923, 0.004174135470006, 0.004222867261147, 0.004271260099287,
		0.004319302644639, 0.004366983619032, 0.004414291809249, 0.004461216070342,
		0.004507745328939, 0.004553868586522, 0.004599574922703, 0.004644853498462,
		0.004689693559382, 0.004734084438848, 0.004778015561229, 0.004821476445043,
		0.004864456706083, 0.004906946060525, 0.004948934328014, 0.004990411434711,
		0.005031367416316, 0.005071792421064, 0.005111676712684, 0.005151010673329,
		0.005189784806474, 0.005227989739773, 0.005265616227894, 0.005302655155303,
		0.005339097539019, 0.005374934531331, 0.005410157422475, 0.005444757643271,
		0.005478726767714, 0.005512056515536, 0.005544738754714, 0.005576765503936,
		0.00560812893503, 0.005638821375341, 0.005668835310063, 0.005698163384527,
		0.005726798406438, 0.005754733348069, 0.005781961348402, 0.005808475715215,
		0.00583426992713, 0.005859337635601,  0.00588367266685, 0.005907269023757,
		0.005930120887688,  0.00595222262028, 0.005973568765159, 0.005994154049614,
		0.006013973386209, 0.006033021874341,  0.00605129480174, 0.006068787645915,
		0.006085496075538, 0.006101415951773, 0.006116543329544, 0.006130874458747,
		0.006144405785399, 0.006157133952728, 0.006169055802207, 0.006180168374519,
		0.006190468910469, 0.006199954851831, 0.006208623842131, 0.006216473727377,
		0.006223502556714, 0.006229708583028, 0.006235090263483, 0.006239646259992,
		0.006243375439632, 0.006246276874989, 0.006248349844446, 0.006249593832405,
		0.006250008529441, 0.006249593832405, 0.006248349844446, 0.006246276874989,
		0.006243375439632, 0.006239646259992, 0.006235090263483, 0.006229708583028,
		0.006223502556714, 0.006216473727377, 0.006208623842131, 0.006199954851831,
		0.006190468910469, 0.006180168374519, 0.006169055802207, 0.006157133952728,
		0.006144405785399, 0.006130874458747, 0.006116543329544, 0.006101415951773,
		0.006085496075538, 0.006068787645915,  0.00605129480174, 0.006033021874341,
		0.006013973386209, 0.005994154049614, 0.005973568765159,  0.00595222262028,
		0.005930120887688, 0.005907269023757,  0.00588367266685, 0.005859337635601,
		0.00583426992713, 0.005808475715215, 0.005781961348402, 0.005754733348069,
		0.005726798406438, 0.005698163384527, 0.005668835310063, 0.005638821375341,
		0.00560812893503, 0.005576765503936, 0.005544738754714, 0.005512056515536,
		0.005478726767714, 0.005444757643271, 0.005410157422475, 0.005374934531331,
		0.005339097539019, 0.005302655155303, 0.005265616227894, 0.005227989739773,
		0.005189784806474, 0.005151010673329, 0.005111676712684, 0.005071792421064,
		0.005031367416316, 0.004990411434711, 0.004948934328014, 0.004906946060525,
		0.004864456706083, 0.004821476445043, 0.004778015561229, 0.004734084438848,
		0.004689693559382, 0.004644853498462, 0.004599574922703, 0.004553868586522,
		0.004507745328939, 0.004461216070342, 0.004414291809249, 0.004366983619032,
		0.004319302644639, 0.004271260099287, 0.004222867261147, 0.004174135470006,
		0.004125076123923, 0.004075700675867, 0.004026020630345, 0.003976047540018,
		0.003925793002309, 0.003875268656005, 0.003824486177847, 0.003773457279116,
		0.003722193702214, 0.003670707217244, 0.003619009618583, 0.003567112721455,
		0.003515028358506, 0.003462768376376, 0.003410344632277,  0.00335776899057,
		0.003305053319348, 0.003252209487027, 0.003199249358937, 0.003146184793927,
		0.003093027640977, 0.003039789735814, 0.002986482897551, 0.002933118925322,
		0.002879709594947, 0.002826266655598, 0.002772801826486, 0.002719326793564,
		0.002665853206247,  0.00261239267415, 0.002558956763844, 0.002505556995639,
		0.002452204840377, 0.002398911716261, 0.002345688985698, 0.002292547952167,
		0.00223949985712, 0.002186555876903, 0.002133727119705, 0.002081024622537,
		0.002028459348242, 0.001976042182534, 0.001923783931063, 0.001871695316523,
		0.001819786975786, 0.001768069457068, 0.001716553217137, 0.001665248618552,
		0.001614165926936, 0.001563315308297, 0.001512706826373, 0.001462350440029,
		0.001412256000682, 0.001362433249779, 0.001312891816305, 0.001263641214341,
		0.001214690840658, 0.001166049972365, 0.001117727764586, 0.001069733248198,
		0.001022075327601,0.0009747627785437,0.0009278042459905,0.0008812082420383,
	0.0008349831438799,0.0007891371918172,0.0007436784873226,0.0006986149911499,
	0.0006539545214959,0.0006097047522125, 0.000565873211069,0.0005224672780673,
	0.0004794941838078,0.0004369610079083,0.0003948746774756,0.0003532419656301,
		0.000312069490084,0.0002713637117733,0.0002311309335435,0.0001913772988908,
	0.0001521087907568,0.0001133312303792,7.505027619683e-05,3.727142281056e-05,
		2.30871393056e-19,-3.675882820441e-05,-7.300006439314e-05,-0.0001087188785933,
	-0.0001439106090279,-0.0001785707628196,-0.0002126950166368,-0.0002462792172847,
	-0.0002793193822386,-0.0003118117001219,-0.0003437525311267,-0.0003751384073785,
	-0.0004059660332443,-0.0004362322855842,-0.0004659342139471,-0.0004950690407101,
	-0.0005236341611617,-0.0005516271435292,-0.0005790457289508,-0.0006058878313912,
	-0.000632151537503,-0.0006578351064322,-0.0006829369695691,-0.0007074557302446,
	-0.0007313901633718,-0.0007547392150344,-0.0007775020020203,-0.0007996778113027,
	-0.0008212660994676,-0.0008422664920887,-0.0008626787830505,-0.0008825029338185,
	-0.000901739072659,-0.0009203874938075,-0.0009384486565858,-0.0009559231844705,
		-0.00097281186411,-0.0009891156442944,-0.001004835634875,-0.001019973105637,
	-0.001034529485124,-0.001048506359416, -0.00106190547086,-0.001074728716758,
	-0.001086978148004,-0.001098655967683,-0.001109764529622,-0.001120306336898,
	-0.001130284040306,-0.001139700436782,-0.001148558467788,-0.001156861217653,
	-0.001164611911875,-0.001171813915389,-0.001178470730789,-0.001184585996517,
	-0.001190163485014,-0.001195207100838,-0.001199720878739, -0.00120370898171,
	-0.001207175698995, -0.00121012544407,-0.001212562752591,-0.001214492280307,
	-0.001215918800949,-0.001216847204084,-0.001217282492946,-0.001217229782229,
	-0.001216694295869,-0.001215681364784,-0.001214196424598, -0.00121224501334,
	-0.001209832769116,-0.001206965427765,-0.001203648820482,-0.001199888871434,
	-0.001195691595351,-0.001191063095089,-0.001186009559192,-0.001180537259424,
	-0.001174652548291,-0.001168361856543,-0.001161671690671, -0.00115458863038,
	-0.001147119326055,-0.001139270496218, -0.00113104892497,-0.001122461459423,
	-0.001113515007131,-0.001104216533505,-0.001094573059223,-0.001084591657639,
	-0.001074279452183,-0.001063643613756,-0.001052691358127,-0.001041429943324,
	-0.001029866667024,-0.001018008863944,-0.001005863903235,-0.0009934391858719,
	-0.0009807421420524,-0.0009677802285934,-0.0009545609263364,-0.0009410917375559,
	-0.0009273801833745,-0.0009134338011848,-0.0008992601420797,-0.0008848667682909,
	-0.0008702612506378,-0.0008554511659856,-0.0008404440947164,-0.0008252476182114,
	-0.0008098693163462,-0.0007943167650007,-0.0007785975335826,-0.0007627191825674,
	-0.0007466892610541,-0.000730515304338,-0.0007142048315016,-0.0006977653430241,
	-0.0006812043184101,-0.0006645292138384,-0.0006477474598324,-0.0006308664589509,
	-0.0006138935835021,-0.0005968361732809,-0.0005797015333288,-0.0005624969317193,
	-0.0005452295973679,-0.000527906717868,-0.0005105354373532,-0.0004931228543864,
	-0.0004756760198769,-0.0004582019350257,-0.0004407075492996,-0.0004231997584346,
	-0.0004056854024697,-0.0003881712638108,-0.0003706640653265,-0.0003531704684742,
	-0.0003356970714603,-0.0003182504074309,-0.0003008369426975,-0.0002834630749952,
	-0.0002661351317754,-0.0002488593685332,-0.0002316419671689,-0.0002144890343863,
	-0.0001974066001253,-0.0001804006160317,-0.0001634769539629,-0.0001466414045306,
	-0.000129899675681,-0.0001132573913124,-9.672008992989e-05,-8.029322333966e-05,
	-6.398215538024e-05,-4.779216069324e-05,-3.17284235327e-05,-1.579603661367e-05,
	-1.961712020187e-19,1.565477996819e-05,3.116349170741e-05,4.652141938383e-05,
	6.172394386616e-05,7.676654363855e-05,9.164479567304e-05,0.0001063543762617,
	0.0001208910618083,0.0001352507295795, 0.000149429358415,0.0001634230293981,
	0.0001772279264841,0.0001908403370896,0.0002042566526396,0.0002174733690753,
	0.0002304870873207,0.0002432945137081,0.0002558924603641,0.0002682778455549,
	0.0002804476939905,  0.00029239913709,0.0003041294132056,0.0003156358678076,
	0.0003269159536289,0.0003379672307705,0.0003487873667671,0.0003593741366136,
	0.0003697254227527,0.0003798392150237,0.0003897136105723,0.0003993468137228,
	0.0004087371358119,0.0004178829949843,0.0004267829159517,0.0004354355297139,
	0.0004438395732435,0.0004519938891336,0.0004598974252099,0.0004675492341065,
	0.0004749484728062,0.0004820944021463,0.0004889863862889,0.0004956238921573,
	0.0005020064888385,0.0005081338469524,0.0005140057379874,0.0005196220336036,
	0.0005249827049044,0.0005300878216756,0.0005349375515936,0.0005395321594032,
	0.0005438720060645,0.0005479575478704,0.0005517893355348,0.0005553680132523,
	0.0005586943177291,0.0005617690771867,0.0005645932103387,0.0005671677253399,
	0.0005694937187107,0.0005715723742352,0.0005734049618347,0.0005749928364166,
	0.0005763374366999,0.0005774402840172,0.0005783029810944,0.0005789272108083,
	0.0005793147349228,0.0005794673928043, 0.000579387100117,0.0005790758474989,
	0.0005785356992184,0.0005777687918129,0.0005767773327099,0.0005755635988306,
	0.0005741299351778, 0.000572478753407,0.0005706125303838,0.0005685338067253,
		0.000566245185329,0.0005637493298874,0.0005610489633913,0.0005581468666198,
	0.0005550458766201,0.0005517488851765,0.0005482588372693,0.0005445787295244,
	0.0005407116086544,0.0005366605698917,0.0005324287554141,0.0005280193527643,
	0.0005234355932625, 0.000518680750414,0.0005137581383126, 0.000508671110039,
	0.0005034230560562,0.0004980174026024,0.0004924576100807,0.0004867471714487,
	0.0004808896106058,0.0004748884807809,0.0004687473629208,0.0004624698640785,
		0.000456059615804,0.0004495202725369,0.0004428555100017,0.0004360690236068,
	0.0004291645268472, 0.000422145749712,0.0004150164370966,0.0004077803472216,
	0.0004004412500569,0.0003930029257532,0.0003854691630815,0.0003778437578794,
	0.0003701305115072,0.0003623332293121, 0.000354455719103,0.0003465017896343,
	0.0003384752491018,0.0003303799036484,0.0003222195558828,0.0003139980034093,
	0.0003057190373712,0.0002973864410071,0.0002890039882202,0.0002805754421632,
	0.0002721045538364,0.0002635950607014,0.0002550506853108,0.0002464751339526,
	0.0002378720953125,0.0002292452391514,0.0002205982150013,0.0002119346508784,
	0.0002032581520135,0.0001945722996018,0.0001858806495709,0.0001771867313673,
	0.0001684940467637,0.0001598060686846,0.0001511262400528,0.0001424579726562,
		0.000133804646035,0.0001251696063902,0.0001165561655134,0.0001079675997379,
		9.94071489118e-05,9.087801539336e-05,8.238336306837e-05,7.392631639027e-05,
		6.55099594431e-05,5.713733502739e-05, 4.88114437693e-05,4.053524325314e-05,
	3.231164717755e-05,2.414352453536e-05,1.603369881747e-05,7.984947240704e-06,
	1.487944084201e-19,-7.918460455146e-06,-1.576780011972e-05,-2.354543410767e-05,
	-3.124882730171e-05,-3.887549497835e-05,-4.642300340812e-05,-5.388897043084e-05,
	-6.127106600599e-05,-6.856701273803e-05,-7.57745863767e-05,-8.289161629226e-05,
	-8.991598592561e-05,-9.684563321343e-05,-0.0001036785509881,-0.0001104127873527,
	-0.0001170464460308,-0.0001235776866917,-0.0001300047252498,-0.0001363258341403,
	-0.000142539342569,-0.000148643636738,-0.0001546371600463,-0.0001605184132664,
	-0.0001662859546958,-0.0001719384002842,-0.0001774744237374,-0.0001828927565957,
	-0.0001881921882892,-0.0001933715661692,-0.0001984297955161,-0.0002033658395228,
	-0.0002081787192564,-0.0002128675135953,-0.0002174313591443,-0.0002218694501267,
	-0.0002261810382533,-0.0002303654325704,-0.000234421999284,-0.0002383501615637,
	-0.0002421493993241,-0.000245819248985,-0.0002493593032104,-0.0002527692106269,
	-0.0002560486755212,-0.0002591974575175,-0.0002622153712348,-0.0002651022859241,
	-0.0002678581250867,-0.000270482866073,-0.0002729765396622,-0.000275339229624,
	-0.0002775710722616,-0.0002796722559371,-0.0002816430205788,-0.0002834836571718,
	-0.0002851945072314,-0.0002867759622596,-0.0002882284631864,-0.0002895524997934,
	-0.000290748610124,-0.0002918173798765,-0.0002927594417836,-0.0002935754749767,
	-0.000294266204337,-0.0002948323998314,-0.0002952748758367,-0.0002955944904498,
	-0.0002957921447853,-0.0002958687822615,-0.0002958253878739,-0.0002956629874579,
	-0.0002953826469395,-0.0002949854715768,-0.0002944726051896,-0.0002938452293803,
	-0.0002931045627445,-0.0002922518600736,-0.0002912884115475,-0.0002902155419194,
	-0.0002890346096935,-0.000287747006294,-0.0002863541552278,-0.0002848575112402,
	-0.0002832585594645,-0.0002815588145655,-0.0002797598198776,-0.0002778631465379,
	-0.0002758703926144,-0.0002737831822303,-0.0002716031646837,-0.0002693320135645,
	-0.0002669714258679,-0.0002645231211051,-0.0002619888404118,-0.0002593703456548,
	-0.0002566694185367,-0.0002538878596999,-0.0002510274878296,-0.0002480901387564,
	-0.0002450776645588,-0.000241991932666,-0.0002388348249619,-0.0002356082368895,
	-0.000232314076557,-0.0002289542638462,-0.0002255307295221,-0.0002220454143461,
	-0.0002185002681912,-0.0002148972491608,-0.0002112383227114,-0.0002075254607785,
	-0.0002037606409072,-0.0001999458453875,-0.0001960830603939,-0.0001921742751313,
	-0.0001882214809851,-0.0001842266706781,-0.0001801918374336,-0.0001761189741443,
	-0.0001720100725485,-0.0001678671224135,-0.0001636921107255,-0.0001594870208886,
		-0.00015525383193,-0.0001509945177148,-0.0001467110461686,-0.0001424053785088,
	-0.0001380794684853,-0.0001337352616297,-0.000129374694515,-0.000124999694024,
	-0.0001206121766282,-0.0001162140476767,-0.0001118072006959,-0.0001073935166989,
	-0.0001029748635066,-9.855309507971e-05,-9.413005086124e-05,-8.970755513135e-05,
	-8.528741637317e-05,-8.087142665066e-05,-7.646136099832e-05,-7.205897682298e-05,
	-6.766601331798e-05,-6.328419088959e-05,-5.891521059616e-05,-5.456075359985e-05,
	-5.022248063126e-05,-4.590203146699e-05,-4.160102442029e-05,-3.732105584492e-05,
	-3.306369965227e-05,-2.88305068419e-05,-2.462300504561e-05,-2.044269808501e-05,
	-1.629106554284e-05,-1.216956234797e-05,-8.079618374202e-06,-4.022638052985e-06,
	-9.991828735722e-20,3.986943344262e-06,7.936866059914e-06,1.184846907904e-05,
	1.572048050299e-05,1.955165590556e-05, 2.33407786221e-05,2.708666002442e-05,
	3.078813978162e-05,3.444408610679e-05,3.805339598955e-05, 4.16149954145e-05,
		4.51278395656e-05,4.859091301645e-05,5.200322990655e-05,5.536383410358e-05,
	5.867179935168e-05,6.192622940589e-05,6.512625815271e-05,6.827104971681e-05,
	7.135979855413e-05,7.439172953125e-05,7.736609799116e-05,8.028218980561e-05,
	8.313932141396e-05,8.593683984882e-05,8.867412274834e-05,9.135057835547e-05,
	9.396564550418e-05,9.651879359277e-05, 9.90095225444e-05,0.0001014373627549,
	0.0001038018750283,0.0001061026504993,0.0001083393105445,0.0001105115066802,
	0.0001126189204496, 0.000114661263297,0.0001166382764308,0.0001185497306751,
	0.0001203954263093,0.0001221751928976, 0.000123888889106,0.0001255364025095,
	0.0001271176493884,0.0001286325745134,0.0001300811509214,  0.00013146337968,
	0.0001327792896431,0.0001340289371957,0.0001352124059898,0.0001363298066705,
	0.0001373812765929,0.0001383669795304,0.0001392871053736,0.0001401418698207,
	0.0001409315140599, 0.000141656304443,0.0001423165321514,0.0001429125128545,
	0.0001434445863595,0.0001439131162554,0.0001443184895483,0.0001446611162912,
	0.0001449414292054,0.0001451598832976,0.0001453169554684,0.0001454131441166,
	0.0001454489687365,0.0001454249695105,0.0001453417068954,0.0001451997612043,
	0.0001449997321831,0.0001447422385827,0.0001444279177263,0.0001440574250728,
		0.000143631433776,  0.00014315063424, 0.000142615733671,0.0001420274556261,
	0.0001413865395582,0.0001406937403589,0.0001399498278983, 0.000139155586562,
	0.0001383118147869,0.0001374193245935, 0.000136478941118,0.0001354915021415,
	0.0001344578576189,0.0001333788692059,0.0001322554097856, 0.000131088362994,
	0.0001298786227451,0.0001286270927565,0.0001273346860733,0.0001260023245939,
		0.000124630938595,0.0001232214662576,0.0001217748531937,0.0001202920519738,
		0.000118774021656, 0.000117221727316,0.0001156361395786,0.0001140182341515,
	0.0001123689913605,0.0001106893956869,0.0001089804353076,0.0001072431016372,
	0.0001054783888729,0.0001036872935423,0.0001018708140545,0.0001000299502538,
	9.816570297696e-05,9.627907361455e-05,9.437106367507e-05,9.244267435356e-05,
	9.049490610397e-05, 8.85287582157e-05,8.654522839452e-05,8.454531234784e-05,
	8.253000337463e-05, 8.05002919601e-05, 7.84571653752e-05,7.640160728115e-05,
	7.433459733912e-05,7.225711082514e-05,7.017011825045e-05,6.807458498733e-05,
	6.597147090054e-05,6.386172998452e-05,6.174631000645e-05,5.962615215524e-05,
	5.750219069659e-05,5.537535263424e-05,5.324655737737e-05,5.111671641449e-05,
	4.898673299365e-05, 4.68575018092e-05,4.472990869519e-05,4.260483032536e-05,
	4.048313391999e-05,3.836567695944e-05,3.625330690472e-05,3.414686092488e-05,
	3.204716563148e-05,2.995503682011e-05,2.787127921901e-05,2.579668624489e-05,
	2.373203976589e-05,2.167810987185e-05,1.963565465185e-05,1.760541997906e-05,
	1.558813930294e-05, 1.35845334488e-05,1.159531042483e-05,9.621165236414e-06,
	7.662779708042e-06,5.720822312529e-06,3.795948007764e-06,1.888798080899e-06,
			5.861030723e-20,-1.869832726835e-06,-3.720100684908e-06,-5.550218678901e-06,
	-7.359615851415e-06,-9.147735794096e-06,-1.091403665134e-05,-1.265799121663e-05,
	-1.437908702151e-05,-1.607682641721e-05,-1.775072664899e-05,-1.940031992318e-05,
	-2.102515346707e-05,-2.262478958147e-05,-2.419880568626e-05,-2.574679435875e-05,
	-2.726836336497e-05,-2.876313568403e-05,-3.023074952544e-05,-3.16708583396e-05,
	-3.308313082139e-05,-3.446725090703e-05,-3.582291776421e-05,-3.714984577552e-05,
	-3.844776451542e-05,-3.971641872055e-05,-4.095556825375e-05,-4.21649880616e-05,
	-4.334446812575e-05,-4.449381340802e-05,-4.561284378939e-05,-4.670139400296e-05,
	-4.775931356093e-05,-4.878646667574e-05,-4.978273217547e-05,-5.074800341348e-05,
	-5.168218817253e-05,-5.25852085634e-05,-5.34570009181e-05,-5.429751567776e-05,
	-5.51067172754e-05,-5.588458401353e-05,-5.663110793676e-05,-5.734629469962e-05,
	-5.803016342946e-05,-5.868274658476e-05,-5.930408980888e-05,-5.989425177928e-05,
	-6.045330405249e-05,-6.098133090474e-05,-6.147842916854e-05,-6.19447080652e-05,
	-6.238028903352e-05,-6.278530555457e-05,-6.315990297296e-05,-6.350423831441e-05,
	-6.381848009998e-05,-6.41028081569e-05,-6.435741342631e-05,-6.458249776778e-05,
	-6.477827376095e-05,-6.494496450429e-05,-6.508280341112e-05,-6.519203400305e-05,
	-6.527290970089e-05,-6.532569361318e-05,-6.535065832253e-05,-6.53480856697e-05,
	-6.531826653577e-05,-6.526150062237e-05,-6.517809623012e-05,-6.506837003537e-05,
	-6.493264686548e-05,-6.47712594726e-05,-6.458454830613e-05,-6.437286128401e-05,
	-6.413655356295e-05,-6.38759873076e-05,-6.359153145901e-05,-6.328356150218e-05,
	-6.295245923314e-05,-6.25986125254e-05,-6.222241509606e-05,-6.182426627164e-05,
	-6.140457075362e-05,-6.096373838407e-05,-6.050218391118e-05,-6.002032675497e-05,
	-5.951859077328e-05,-5.899740402807e-05,-5.845719855219e-05,-5.789841011669e-05,
	-5.732147799882e-05,-5.672684475075e-05,-5.611495596916e-05,-5.548626006582e-05,
	-5.484120803912e-05,-5.418025324684e-05,-5.350385118012e-05,-5.281245923874e-05,
	-5.210653650782e-05,-5.138654353606e-05,-5.065294211553e-05,-4.990619506316e-05,
	-4.914676600397e-05,-4.837511915614e-05,-4.759171911807e-05,-4.679703065734e-05,
	-4.59915185018e-05,-4.517564713283e-05,-4.434988058081e-05,-4.351468222285e-05,
	-4.267051458299e-05,-4.181783913469e-05, -4.0957116106e-05,-4.008880428712e-05,
	-3.921336084076e-05,-3.833124111503e-05,-3.744289845923e-05,-3.654878404235e-05,
	-3.564934667447e-05,-3.474503263109e-05,-3.38362854804e-05,-3.292354591358e-05,
	-3.200725157819e-05,-3.108783691466e-05,-3.01657329959e-05,-2.924136737018e-05,
	-2.83151639072e-05,-2.738754264746e-05,-2.645891965493e-05,-2.552970687306e-05,
	-2.460031198424e-05,-2.367113827255e-05,-2.27425844901e-05,-2.18150447267e-05,
	-2.088890828312e-05,-1.996455954782e-05,-1.904237787724e-05,-1.812273747962e-05,
	-1.720600730241e-05,-1.62925509233e-05,-1.53827264448e-05,-1.447688639248e-05,
	-1.357537761678e-05,-1.267854119856e-05,-1.178671235817e-05,-1.090022036822e-05,
	-1.001938847004e-05,-9.144533793713e-06,-8.275967281802e-06,-7.413993616723e-06,
	-6.558911151751e-06,-5.711011845666e-06,-4.870581201034e-06,-4.037898206105e-06,
	-3.213235280325e-06,-2.39685822345e-06,-1.589026168236e-06,-7.899915367138e-07,
	-2.939120998031e-20,7.807095583408e-07,1.551905075428e-06,2.313361338701e-06,
	3.064860012082e-06, 3.80618965869e-06, 4.53714576014e-06,5.257530732439e-06,
	5.967153938519e-06,6.665831697435e-06,7.353387290249e-06,8.029650962647e-06,
	8.694459924315e-06,9.347658345097e-06,9.989097347999e-06,1.061863499904e-05,
	1.123613629404e-05,1.184147314228e-05,1.243452434725e-05,1.301517558431e-05,
	1.358331937551e-05,1.413885506144e-05,1.468168877031e-05,1.521173338415e-05,
	1.572890850232e-05,1.623314040226e-05,1.672436199761e-05,1.720251279372e-05,
	1.766753884053e-05,1.811939268302e-05,1.855803330915e-05, 1.89834260954e-05,
	1.939554274992e-05,1.979436125337e-05,2.017986579757e-05,2.055204672187e-05,
	2.091090044737e-05, 2.12564294091e-05,2.158864198612e-05,2.190755242961e-05,
	2.221318078908e-05,2.250555283668e-05,2.278469998968e-05,2.305065923119e-05,
	2.330347302921e-05,2.354318925397e-05,2.376986109372e-05,2.398354696897e-05,
	2.418431044526e-05,2.437222014451e-05,2.454734965498e-05,2.470977743995e-05,
	2.485958674519e-05,2.499686550513e-05,2.512170624803e-05,2.523420599995e-05,
	2.533446618783e-05,2.542259254148e-05,2.549869499479e-05,2.556288758597e-05,
	2.561528835711e-05,2.565601925295e-05,2.568520601899e-05,2.570297809895e-05,
	2.570946853173e-05,2.570481384779e-05,2.568915396511e-05,2.566263208475e-05,
	2.562539458608e-05,2.557759092165e-05,2.551937351195e-05,2.545089763982e-05,
	2.537232134487e-05,2.528380531776e-05,2.518551279443e-05,2.507760945037e-05,
	2.496026329503e-05,2.483364456621e-05,2.469792562475e-05,2.455328084937e-05,
	2.439988653182e-05, 2.42379207723e-05,2.406756337526e-05,2.388899574565e-05,
	2.370240078553e-05,2.350796279128e-05,2.330586735127e-05,2.309630124415e-05,
	2.287945233778e-05, 2.26555094888e-05,2.242466244289e-05,2.218710173585e-05,
		2.19430185954e-05,2.169260484382e-05,2.143605280149e-05,2.117355519127e-05,
	2.090530504388e-05,2.063149560416e-05,2.035232023849e-05,2.006797234304e-05,
	1.977864525328e-05,1.948453215447e-05,1.918582599336e-05,1.888271939097e-05,
	1.857540455665e-05,1.826407320328e-05,1.794891646379e-05,1.763012480885e-05,
	1.730788796601e-05,1.698239483998e-05,1.665383343439e-05,1.632239077488e-05,
	1.598825283352e-05,1.565160445475e-05,1.531262928263e-05,1.497150968963e-05,
	1.462842670681e-05,1.428355995557e-05,1.393708758079e-05,1.358918618557e-05,
	1.324003076745e-05, 1.28897946562e-05, 1.25386494531e-05,1.218676497191e-05,
	1.183430918125e-05,1.148144814867e-05,1.112834598633e-05,1.077516479815e-05,
	1.042206462875e-05,1.006920341383e-05,9.716736932261e-06,9.364818759816e-06,
		9.01360022444e-06,8.663230363227e-06,8.313855880987e-06,7.965621110457e-06,
	7.618667974139e-06, 7.27313594777e-06,6.929162025416e-06,6.586880686199e-06,
	6.246423862642e-06,5.907920910635e-06,5.571498581014e-06,5.237280992754e-06,
	4.905389607759e-06,4.575943207253e-06,4.249057869757e-06,3.924846950649e-06,
	3.603421063294e-06,3.284888061734e-06,2.969353024935e-06,2.656918242571e-06,
	2.347683202335e-06,2.041744578773e-06,1.739196223617e-06,1.440129157612e-06,
	1.144631563815e-06,8.527887823615e-07,5.646833066743e-07,2.803947811071e-07,
	1.215581681048e-20,-2.764270918656e-07,-5.488153974313e-07,-8.170966641633e-07,
	-1.081205479509e-06,-1.341079265026e-06,-1.596658269211e-06,-1.847885559026e-06,
	-2.094707010178e-06,-2.337071296134e-06,-2.574929875918e-06, -2.8082369807e-06,
	-3.036949599208e-06,-3.261027461965e-06,-3.480433024401e-06,-3.69513144884e-06,
	-3.905090585392e-06,-4.110280951775e-06,-4.310675712096e-06,-4.506250654594e-06,
	-4.696984168396e-06,-4.882857219284e-06,-5.063853324523e-06,-5.23995852675e-06,
	-5.411161366966e-06,-5.577452856647e-06,-5.738826449001e-06,-5.895278009399e-06,
	-6.046805785001e-06,-6.193410373602e-06,-6.335094691732e-06,-6.471863942019e-06,
	-6.603725579857e-06,-6.730689279398e-06,-6.852766898889e-06,-6.969972445386e-06,
	-7.082322038871e-06,-7.189833875791e-06,-7.292528192051e-06,-7.390427225484e-06,
	-7.483555177823e-06,-7.571938176204e-06,-7.655604234217e-06,-7.73458321254e-06,
	-7.808906779179e-06,-7.87860836933e-06,-7.943723144904e-06,-8.004287953722e-06,
	-8.060341288421e-06,-8.111923245084e-06,-8.159075481625e-06,-8.201841175946e-06,
	-8.240264983905e-06,-8.274392997093e-06,-8.304272700478e-06,-8.329952929904e-06,
	-8.351483829492e-06,-8.368916808963e-06,-8.382304500895e-06,-8.391700717941e-06,
	-8.397160410044e-06,-8.398739621644e-06,-8.396495448925e-06,-8.390485997108e-06,
	-8.380770337814e-06,-8.367408466519e-06,-8.350461260127e-06,-8.329990434667e-06,
	-8.306058503149e-06,-8.278728733587e-06,-8.24806510722e-06,-8.214132276933e-06,
	-8.176995525914e-06,-8.136720726559e-06,-8.093374299629e-06,-8.047023173705e-06,
	-7.997734744931e-06,-7.945576837072e-06,-7.890617661914e-06,-7.832925779995e-06,
	-7.772570061719e-06,-7.709619648828e-06,-7.644143916285e-06,-7.576212434548e-06,
	-7.505894932282e-06,-7.433261259492e-06,-7.358381351109e-06,-7.281325191044e-06,
	-7.202162776699e-06,-7.120964083981e-06,-7.037799032801e-06,-6.952737453084e-06,
	-6.865849051302e-06,-6.777203377527e-06,-6.686869793029e-06,-6.594917438427e-06,
	-6.501415202382e-06,-6.406431690877e-06,-6.31003519705e-06,-6.212293671627e-06,
	-6.113274693936e-06,-6.013045443514e-06,-5.911672672333e-06,-5.809222677614e-06,
	-5.705761275277e-06,-5.601353773999e-06,-5.496064949901e-06,-5.389959021872e-06,
	-5.283099627514e-06,-5.175549799745e-06,-5.067371944025e-06,-4.95862781624e-06,
	-4.849378501231e-06,-4.739684391972e-06,-4.629605169399e-06,-4.519199782897e-06,
	-4.408526431442e-06,-4.297642545392e-06,-4.186604768945e-06,-4.075468943246e-06,
	-3.964290090154e-06,-3.853122396662e-06,-3.742019199975e-06,-3.631032973241e-06,
	-3.520215311936e-06,-3.40961692089e-06,-3.299287601978e-06,-3.18927624244e-06,
	-3.079630803851e-06,-2.970398311736e-06,-2.861624845807e-06,-2.753355530851e-06,
	-2.645634528225e-06,-2.538505027998e-06,-2.432009241691e-06,-2.326188395648e-06,
	-2.221082725009e-06,-2.116731468286e-06,-2.013172862543e-06,-1.910444139164e-06,
	-1.80858152021e-06,-1.707620215356e-06, -1.6075944194e-06,-1.508537310342e-06,
	-1.410481048018e-06,-1.313456773292e-06,-1.217494607794e-06,-1.122623654186e-06,
	-1.028871996969e-06,-9.362667038073e-07,-8.448338273668e-07,-7.545984076577e-07,
	-6.655844748768e-07,-5.77815052736e-07,-4.913121622721e-07,-4.06096826126e-07,
	-3.221890732841e-07,-2.396079442732e-07,-1.583714967968e-07,-7.849681180708e-08,
	-3.882092462702e-21,7.710379127398e-08,1.528003706946e-07,2.270764952611e-07,
	2.999198621958e-07,3.713191004725e-07,4.412637619792e-07,5.097443123255e-07,
	5.767521213042e-07,6.422794530186e-07,7.063194556839e-07,7.688661511145e-07,
	8.299144239063e-07,8.894600103255e-07,9.474994869131e-07,1.004030258816e-06,
	1.059050547853e-06,1.112559380335e-06,1.164556574629e-06,1.215042728507e-06,
	1.264019206258e-06,1.311488125597e-06, 1.35745234437e-06,1.401915447066e-06,
	1.444881731151e-06, 1.48635619323e-06,1.526344515048e-06,1.564853049338e-06,
	1.601888805531e-06,1.637459435337e-06,1.671573218195e-06,1.704239046626e-06,
	1.735466411473e-06, 1.76526538705e-06,1.793646616219e-06,1.820621295376e-06,
	1.846201159391e-06,1.870398466481e-06,1.893225983043e-06, 1.91469696845e-06,
	1.934825159817e-06,1.953624756754e-06,1.971110406098e-06, 1.98729718666e-06,
	2.002200593961e-06,2.015836524995e-06,2.028221263015e-06,2.039371462344e-06,
		2.04930413323e-06,2.058036626747e-06,2.065586619755e-06,2.071972099913e-06,
	2.077211350773e-06,2.081322936941e-06,2.084325689329e-06,2.086238690496e-06,
	2.087081260084e-06,2.086872940362e-06,2.085633481879e-06,2.083382829234e-06,
	2.080141106972e-06,2.075928605603e-06,2.070765767763e-06,2.064673174513e-06,
	2.057671531781e-06,2.049781656961e-06,2.041024465664e-06,2.031420958636e-06,
	2.020992208836e-06, 2.00975934869e-06,1.997743557521e-06,1.984966049153e-06,
		1.97144805971e-06, 1.95721083559e-06,1.942275621642e-06,1.926663649536e-06,
	1.910396126326e-06,1.893494223224e-06,1.875979064577e-06,1.857871717051e-06,
	1.839193179025e-06,1.819964370206e-06,1.800206121457e-06, 1.77993916484e-06,
	1.759184123887e-06,1.737961504093e-06, 1.71629168363e-06,1.694194904295e-06,
	1.671691262677e-06,1.648800701566e-06,1.625543001581e-06,1.601937773042e-06,
	1.578004448062e-06,1.553762272889e-06,1.529230300467e-06,1.504427383241e-06,
	1.479372166201e-06,1.454083080148e-06,1.428578335213e-06,1.402875914598e-06,
	1.376993568561e-06,1.350948808629e-06,1.324758902057e-06,1.298440866509e-06,
		1.27201146498e-06,1.245487200948e-06,1.218884313759e-06,1.192218774241e-06,
		1.16550628055e-06,1.138762254241e-06,1.112001836568e-06,1.085239885007e-06,
	1.058490970007e-06,1.031769371955e-06,1.005089078368e-06,9.784637813029e-07,
	9.519068749728e-07,9.254314535898e-07,8.990503094105e-07,8.727759309939e-07,
	8.466205016653e-07,8.205958981845e-07,7.947136896154e-07,7.689851363948e-07,
	7.434211895969e-07,7.180324903919e-07,6.928293696941e-07,6.678218479981e-07,
	6.430196353996e-07,6.184321317972e-07,5.940684272724e-07,5.699373026453e-07,
	5.460472302012e-07,5.224063745864e-07, 4.99022593869e-07, 4.75903440761e-07,
	4.530561639992e-07,4.304877098808e-07,4.082047239503e-07,3.862135528337e-07,
		3.64520246218e-07,3.431305589695e-07,3.220499533909e-07,3.012836016101e-07,
	2.808363880996e-07,2.607129123208e-07,2.409174914915e-07,2.214541634706e-07,
	2.023266897586e-07,1.835385586076e-07,1.650929882399e-07,1.469929301688e-07,
	1.292410726192e-07,1.118398440445e-07,9.479141673474e-08,7.809771051362e-08,
	6.176039651961e-08,4.578090106798e-08,3.016040958979e-08,1.489987064413e-08,
	8.262514961441e-22,-1.453871521598e-08,-2.871601230967e-08,-4.253184875085e-08,
	-5.598639784987e-08,-6.908004438279e-08,-8.18133801689e-08,-9.418719960394e-08,
	-1.062024951526e-07,-1.178604528039e-07,-1.291624474925e-07,-1.401100384902e-07,
	-1.507049647696e-07,-1.60949140345e-07,-1.708446495921e-07,-1.803937425514e-07,
	-1.89598830217e-07,-1.984624798146e-07,-2.069874100729e-07,-2.15176486489e-07,
	-2.230327165937e-07,-2.305592452167e-07,-2.377593497576e-07,-2.446364354635e-07,
	-2.511940307162e-07,-2.574357823334e-07,-2.633654508841e-07,-2.689869060234e-07,
	-2.743041218471e-07,-2.793211722704e-07,-2.840422264323e-07,-2.884715441273e-07,
	-2.926134712696e-07,-2.964724353883e-07,-3.000529411594e-07,-3.033595659739e-07,
	-3.063969555463e-07,-3.091698195644e-07,-3.116829273828e-07,-3.139411037615e-07,
	-3.159492246529e-07,-3.177122130371e-07,-3.192350348085e-07,-3.205226947157e-07,
	-3.215802323549e-07, -3.2241271822e-07,-3.230252498094e-07,-3.234229477924e-07,
	-3.236109522356e-07,-3.235944188907e-07,-3.233785155455e-07,-3.229684184388e-07,
	-3.223693087409e-07,-3.215863690993e-07,-3.206247802532e-07,-3.194897177151e-07,
	-3.181863485222e-07,-3.167198280573e-07,-3.15095296941e-07,-3.133178779948e-07,
	-3.113926732769e-07,-3.093247611903e-07,-3.071191936642e-07,-3.047809934096e-07,
	-3.023151512486e-07,-2.997266235181e-07,-2.970203295494e-07,-2.942011492214e-07,
	-2.912739205905e-07,-2.88243437595e-07,-2.851144478361e-07,-2.818916504333e-07,
	-2.785796939566e-07,-2.751831744335e-07,-2.717066334318e-07,-2.681545562181e-07,
	-2.645313699906e-07,-2.608414421874e-07,-2.570890788697e-07,-2.532785231785e-07,
	-2.494139538657e-07,-2.454994838987e-07,-2.415391591381e-07,-2.375369570877e-07,
	-2.334967857164e-07,-2.294224823524e-07,-2.253178126468e-07,-2.211864696087e-07,
	-2.17032072709e-07,-2.128581670532e-07,-2.086682226222e-07,-2.044656335803e-07,
	-2.002537176493e-07,-1.96035715549e-07,-1.918147905012e-07,-1.875940277984e-07,
	-1.833764344349e-07,-1.791649387997e-07,-1.749623904309e-07,-1.707715598289e-07,
	-1.665951383294e-07,-1.62435738034e-07,-1.582958917969e-07,-1.541780532684e-07,
	-1.500845969916e-07,-1.460178185535e-07,-1.419799347878e-07,-1.379730840292e-07,
	-1.339993264172e-07,-1.300606442486e-07,-1.261589423785e-07,-1.22296048666e-07,
	-1.184737144665e-07,-1.146936151668e-07,-1.109573507637e-07,-1.072664464833e-07,
	-1.036223534409e-07,-1.000264493392e-07,-9.648003920522e-08,-9.298435616214e-08,
	-8.954056223753e-08,-8.614974920462e-08,-8.281293945642e-08,-7.953108691109e-08,
	-7.630507794736e-08,-7.313573236867e-08,-7.002380439487e-08,-6.696998368011e-08,
	-6.397489635575e-08,-6.103910609704e-08,-5.816311521229e-08,-5.534736575325e-08,
	-5.259224064568e-08,-4.989806483858e-08,-4.726510647114e-08,-4.469357805612e-08,
	-4.218363767836e-08,-3.973539020746e-08,-3.734888852326e-08,-3.502413475308e-08,
	-3.276108151957e-08,-3.055963319798e-08,-2.841964718183e-08,-2.634093515578e-08,
	-2.432326437472e-08,-2.236635894791e-08,-2.046990112723e-08,-1.863353259836e-08,
	-1.685685577406e-08,-1.513943508834e-08,-1.348079829072e-08,-1.188043773955e-08,
	-1.033781169334e-08,-8.852345599374e-09,-7.423433378541e-09,-6.050438705569e-09,
	-4.732696283772e-09,-3.469513113474e-09,-2.26016975327e-09,-1.103921573337e-09,
	-1.478011657745e-21
};
