/*
* SACD Decoder plugin
* Copyright (c) 2011-2022 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _STD_SERVICE_H_INCLUDED
#define _STD_SERVICE_H_INCLUDED

#include <foobar2000.h>
#include <component.h>
#include <set>

class std_service_t : public service_base {
	foobar2000_client* std_foobar2000_client;
public:
	std_service_t(const char* p_module);
	virtual ~std_service_t();
	foobar2000_client* get_client() const;
	template<typename T> bool get_cfg_var(const GUID& p_guid, T& p_value) {
		return get_or_set_cfg_obj(p_guid, &p_value, sizeof(p_value), false) ? byte_order::order_le_to_native_t(p_value), true : false;
	}
	template<typename T> bool set_cfg_var(const GUID& p_guid, T& p_value) {
		byte_order::order_le_to_native_t(p_value);
		return get_or_set_cfg_obj(p_guid, &p_value, sizeof(p_value), true);
	}
	std::set<GUID> get_service_guids();
private:
	bool get_or_set_cfg_obj(const GUID& p_guid, void* p_obj, size_t p_size, bool p_set);
};

#endif
