/*
* SACD Decoder plugin
* Copyright (c) 2011-2023 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _SACD_METABASE_H_INCLUDED
#define _SACD_METABASE_H_INCLUDED

#include "sacd_config.h"
#include "sacd_disc.h"

#define PUGIXML_HEADER_ONLY
#include <pugixml.hpp>
using namespace pugi;

class sacd_metabase_t {
	std::string  store_id;
	std::string  store_path;
	std::string  xml_file;
	xml_document xml_doc;
	bool         initialized;
public:
	sacd_metabase_t(sacd_disc_t* disc, const char* metafile);
	~sacd_metabase_t();
	void get_track_info(uint32_t track_number, file_info& track_info);
	void set_track_info(uint32_t track_number, const file_info& track_info, bool is_linked = false);
	void get_albumart(uint32_t albumart_id, std::vector<t_uint8>& albumart_data);
	void set_albumart(uint32_t albumart_id, const std::vector<t_uint8>& albumart_data);
	void commit();
private:
	bool init_xmldoc(const char* store_type);
	void delete_track_tags(xml_node node_track, const char* tag_type, bool is_linked);
	void insert_track_tag(xml_node node_track, const char* tag_type, const char* tag_name, const char* tag_value);
	xml_node get_node(const char* tag_type, const char* att_id, bool create = false);
	xml_node new_node(const char* tag_type, const char* att_id);
};

#endif
