/*
* SACD Decoder plugin
* Copyright (c) 2011-2024 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with FFmpeg; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _SACD_DSDIFF_H_INCLUDED
#define _SACD_DSDIFF_H_INCLUDED

#include "sacd_config.h"
#include "endianess.h"
#include "scarletbook.h"
#include "sacd_reader.h"
#include "sacd_dsd.h"
#include "id3_tagger.h"
#include <vector>

class sacd_dsdiff_t : public sacd_reader_t {
	sacd_media_t* m_file;
	uint32_t      m_mode;
	uint32_t      m_version;
	uint32_t      m_samplerate;
	uint16_t      m_channel_count;
	uint16_t      m_loudspeaker_config;
	bool          m_dst_encoded;
	uint64_t      m_frm8_size;
	uint64_t      m_dsti_offset;
	uint64_t      m_dsti_size;
	uint64_t      m_data_offset;
	uint64_t      m_data_size;
	uint16_t      m_framerate;
	uint32_t      m_frame_size;
	uint32_t      m_frame_count;
	tracklist_t   m_tracklist;
	id3_tagger_t  m_id3_tagger;
	uint64_t      m_id3_offset;
	uint32_t      m_track_number;                
	uint64_t      m_track_start;
	uint64_t      m_track_end;
	uint64_t      m_read_start;
	uint64_t      m_read_end;
	uint32_t      m_span_frames;
	uint64_t      m_span_start;
	uint64_t      m_span_end;
	framelist_t   m_framelist;
	uint32_t      m_frame_nr;
public:
	sacd_dsdiff_t();
	~sacd_dsdiff_t();
	uint32_t get_track_count(uint32_t mode);
	uint32_t get_track_number(uint32_t track_index);
	int get_channels(uint32_t track_number);
	int get_loudspeaker_config(uint32_t track_number);
	int get_samplerate(uint32_t track_number);
	int get_framerate(uint32_t track_number);
	double get_duration(uint32_t track_number);
	bool is_dst(uint32_t track_number);
	bool is_gapless(uint32_t track_number);
	void set_mode(uint32_t selector, bool is_set);
	bool open(sacd_media_t* p_file);
	bool close();
	bool select_track(uint32_t track_number);
	bool set_track_span(uint32_t span_frames);
	std::tuple<bool, size_t, frame_type_e, frame_span_e> read_frame(uint8_t* frame_data, size_t frame_size);
	bool seek(double seconds);
	void get_info(uint32_t subsong, file_info& info);
	void set_info(uint32_t subsong, const file_info& info);
	void get_albumart(uint32_t albumart_id, vector<t_uint8>& albumart_data);
	void set_albumart(uint32_t albumart_id, const vector<t_uint8>& albumart_data);
	void commit();
private:
	std::tuple<double, double>get_track_times(uint32_t track_number);
	std::tuple<uint64_t, uint64_t> get_track_span(uint32_t track_number);
	uint64_t get_dsti_from_frame(uint32_t frame_nr);
	uint32_t get_frame_from_file_position(uint64_t file_pos);
	uint64_t get_file_position_from_time(double seconds);
	uint32_t get_track_from_time(double seconds);
	void write_id3_tag(const void* data, size_t size);
};

#endif
