/*
* DSD Processor DSP plugin
* Copyright (c) 2016-2023 Maxim V.Anisiutkin <maxim.anisiutkin@gmail.com>
*/

#pragma once

#include <foobar2000.h>

class dsd_processor_service : public service_base {
	FB2K_MAKE_SERVICE_INTERFACE_ENTRYPOINT(dsd_processor_service);
public:
	virtual GUID get_guid() = 0;
	virtual const char* get_name() = 0;
	virtual bool is_active() = 0;
	virtual bool is_changed() = 0;
	virtual void set_volume(double p_volume_dB) = 0;
	virtual bool start(const unsigned p_inp_channels, const unsigned p_inp_samplerate, const unsigned p_inp_channel_config, unsigned& p_out_channels, unsigned& p_out_samplerate, unsigned& p_out_channel_config) = 0;
	virtual void stop() = 0;
	virtual const t_uint8* run(const void* p_inp_pcmdsd, const t_size p_inp_samples, t_size* p_out_samples) = 0;
};
