Name "DSD File ASIO Driver"
OutFile "DSDFileASIOInstall.exe"
InstallDir $PROGRAMFILES\DSDFileASIO
InstallDirRegKey HKLM "Software\DSDFileASIO" "Install_Dir"
RequestExecutionLevel admin
XPStyle on

!include "x64.nsh"

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

Section "DSDFileASIO (required)"

  SectionIn RO
  SetOutPath $INSTDIR
  File "DSDFileASIO.dll"
  RegDLL "$INSTDIR\DSDFileASIO.dll"

  ${If} ${RunningX64}
    File "DSDFileASIO_x64.dll"
    ExecWait '"$SYSDIR\regsvr32.exe" /s "$INSTDIR\DSDFileASIO_x64.dll"'
  ${EndIf}

  ; Write the installation path into the registry
  WriteRegStr HKLM "SOFTWARE\DSDFileASIO" "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "DisplayName" "DSD File ASIO Driver"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "Publisher" "Maxim V.Anisiutkin"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "DisplayVersion" "0.1.1"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\DSDFileASIO"
  DeleteRegKey HKLM SOFTWARE\DSDFileASIO

  UnRegDLL "$INSTDIR\DSDFileASIO.dll"
  Delete $INSTDIR\DSDFileASIO.dll

  ${If} ${RunningX64}
    ExecWait '"$SYSDIR\regsvr32.exe" /s /u "$INSTDIR\DSDFileASIO_x64.dll"'
    Delete $INSTDIR\DSDFileASIO_x64.dll
  ${EndIf}

  Delete $INSTDIR\uninstall.exe

  ; Remove directories used
  RMDir "$SMPROGRAMS\DSDFileASIO"
  RMDir "$INSTDIR"

SectionEnd
